/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dex.spec;

import com.linkedin.dex.parser.ParseUtils;
import com.linkedin.dex.spec.DexException;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B1\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J=\u0010\u0016\u001a\u00020\u00002\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\u0006\u0010\u001e\u001a\u00020\u001fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/linkedin/dex/spec/DexMagic;", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "dex", "", "", "newline", "version", "zero", "(Ljava/util/List;BLjava/util/List;B)V", "getDex", "()Ljava/util/List;", "getNewline", "()B", "getVersion", "getZero", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "validate", "", "parser"})
public final class DexMagic {
    @NotNull
    private final List<Byte> dex;
    private final byte newline;
    @NotNull
    private final List<Byte> version;
    private final byte zero;

    public final void validate() {
        if (((Number)this.dex.get(0)).byteValue() == 100 & ((Number)this.dex.get(1)).byteValue() == 101 & ((Number)this.dex.get(2)).byteValue() == 120 & this.newline == 10 & ((Number)this.version.get(0)).byteValue() == 48 & ((Number)this.version.get(1)).byteValue() == 51 & ((Number)this.version.get(2)).byteValue() >= 53 & this.zero == 0) {
            return;
        }
        throw (Throwable)new DexException("Invalid dexMagic:\n" + this + "\n");
    }

    @NotNull
    public final List<Byte> getDex() {
        return this.dex;
    }

    public final byte getNewline() {
        return this.newline;
    }

    @NotNull
    public final List<Byte> getVersion() {
        return this.version;
    }

    public final byte getZero() {
        return this.zero;
    }

    public DexMagic(@NotNull List<Byte> dex, byte newline, @NotNull List<Byte> version, byte zero) {
        Intrinsics.checkNotNullParameter(dex, (String)"dex");
        Intrinsics.checkNotNullParameter(version, (String)"version");
        this.dex = dex;
        this.newline = newline;
        this.version = version;
        this.zero = zero;
    }

    public DexMagic(@NotNull ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        this(ParseUtils.INSTANCE.parseByteList(byteBuffer, 3), byteBuffer.get(), ParseUtils.INSTANCE.parseByteList(byteBuffer, 3), byteBuffer.get());
    }

    @NotNull
    public final List<Byte> component1() {
        return this.dex;
    }

    public final byte component2() {
        return this.newline;
    }

    @NotNull
    public final List<Byte> component3() {
        return this.version;
    }

    public final byte component4() {
        return this.zero;
    }

    @NotNull
    public final DexMagic copy(@NotNull List<Byte> dex, byte newline, @NotNull List<Byte> version, byte zero) {
        Intrinsics.checkNotNullParameter(dex, (String)"dex");
        Intrinsics.checkNotNullParameter(version, (String)"version");
        return new DexMagic(dex, newline, version, zero);
    }

    public static /* synthetic */ DexMagic copy$default(DexMagic dexMagic, List list, byte by, List list2, byte by2, int n, Object object) {
        if ((n & 1) != 0) {
            list = dexMagic.dex;
        }
        if ((n & 2) != 0) {
            by = dexMagic.newline;
        }
        if ((n & 4) != 0) {
            list2 = dexMagic.version;
        }
        if ((n & 8) != 0) {
            by2 = dexMagic.zero;
        }
        return dexMagic.copy(list, by, list2, by2);
    }

    @NotNull
    public String toString() {
        return "DexMagic(dex=" + this.dex + ", newline=" + this.newline + ", version=" + this.version + ", zero=" + this.zero + ")";
    }

    public int hashCode() {
        List<Byte> list = this.dex;
        List<Byte> list2 = this.version;
        return (((list != null ? ((Object)list).hashCode() : 0) * 31 + this.newline) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + this.zero;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DexMagic)) break block3;
                DexMagic dexMagic = (DexMagic)object;
                if (!Intrinsics.areEqual(this.dex, dexMagic.dex) || this.newline != dexMagic.newline || !Intrinsics.areEqual(this.version, dexMagic.version) || this.zero != dexMagic.zero) break block3;
            }
            return true;
        }
        return false;
    }
}

