/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dex.spec;

import com.linkedin.dex.spec.EncodedValue;
import com.linkedin.dex.spec.Leb128;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ(\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/linkedin/dex/spec/EncodedArray;", "", "size", "", "values", "", "Lcom/linkedin/dex/spec/EncodedValue;", "(I[Lcom/linkedin/dex/spec/EncodedValue;)V", "getSize", "()I", "getValues", "()[Lcom/linkedin/dex/spec/EncodedValue;", "[Lcom/linkedin/dex/spec/EncodedValue;", "component1", "component2", "copy", "(I[Lcom/linkedin/dex/spec/EncodedValue;)Lcom/linkedin/dex/spec/EncodedArray;", "equals", "", "other", "hashCode", "toString", "", "Companion", "parser"})
public final class EncodedArray {
    private final int size;
    @NotNull
    private final EncodedValue[] values;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final EncodedValue[] getValues() {
        return this.values;
    }

    public EncodedArray(int size, @NotNull EncodedValue[] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.size = size;
        this.values = values;
    }

    public final int component1() {
        return this.size;
    }

    @NotNull
    public final EncodedValue[] component2() {
        return this.values;
    }

    @NotNull
    public final EncodedArray copy(int size, @NotNull EncodedValue[] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return new EncodedArray(size, values);
    }

    public static /* synthetic */ EncodedArray copy$default(EncodedArray encodedArray, int n, EncodedValue[] encodedValueArray, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = encodedArray.size;
        }
        if ((n2 & 2) != 0) {
            encodedValueArray = encodedArray.values;
        }
        return encodedArray.copy(n, encodedValueArray);
    }

    @NotNull
    public String toString() {
        return "EncodedArray(size=" + this.size + ", values=" + Arrays.toString(this.values) + ")";
    }

    public int hashCode() {
        return this.size * 31 + (this.values != null ? Arrays.hashCode(this.values) : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof EncodedArray)) break block3;
                EncodedArray encodedArray = (EncodedArray)object;
                if (this.size != encodedArray.size || !Intrinsics.areEqual((Object)this.values, (Object)encodedArray.values)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/linkedin/dex/spec/EncodedArray$Companion;", "", "()V", "create", "Lcom/linkedin/dex/spec/EncodedArray;", "byteBuffer", "Ljava/nio/ByteBuffer;", "parser"})
    public static final class Companion {
        @NotNull
        public final EncodedArray create(@NotNull ByteBuffer byteBuffer) {
            Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
            int size = Leb128.Companion.readUnsignedLeb128(byteBuffer);
            EncodedValue[] encodedValueArray = new EncodedValue[size];
            int n = 0;
            while (n < size) {
                EncodedValue encodedValue;
                int n2 = n;
                int n3 = n++;
                EncodedValue[] encodedValueArray2 = encodedValueArray;
                boolean bl = false;
                encodedValueArray2[n3] = encodedValue = EncodedValue.Companion.create(byteBuffer);
            }
            EncodedValue[] values = encodedValueArray;
            return new EncodedArray(size, values);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

