/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dex.parser;

import com.linkedin.dex.parser.ParseUtils;
import com.linkedin.dex.spec.DexFile;
import com.linkedin.dex.spec.EncodedValue;
import com.linkedin.dex.spec.Leb128;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00032\u00020\u0001:\u000e\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\r\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u00a8\u0006\u001e"}, d2={"Lcom/linkedin/dex/parser/DecodedValue;", "", "()V", "Companion", "DecodedArrayValue", "DecodedBoolean", "DecodedByte", "DecodedChar", "DecodedDouble", "DecodedEnum", "DecodedFloat", "DecodedInt", "DecodedLong", "DecodedNull", "DecodedShort", "DecodedString", "DecodedType", "Lcom/linkedin/dex/parser/DecodedValue$DecodedByte;", "Lcom/linkedin/dex/parser/DecodedValue$DecodedShort;", "Lcom/linkedin/dex/parser/DecodedValue$DecodedChar;", "Lcom/linkedin/dex/parser/DecodedValue$DecodedInt;", "Lcom/linkedin/dex/parser/DecodedValue$DecodedLong;", "Lcom/linkedin/dex/parser/DecodedValue$DecodedFloat;", "Lcom/linkedin/dex/parser/DecodedValue$DecodedDouble;", "Lcom/linkedin/dex/parser/DecodedValue$DecodedString;", "Lcom/linkedin/dex/parser/DecodedValue$DecodedType;", "Lcom/linkedin/dex/parser/DecodedValue$DecodedNull;", "Lcom/linkedin/dex/parser/DecodedValue$DecodedBoolean;", "Lcom/linkedin/dex/parser/DecodedValue$DecodedEnum;", "Lcom/linkedin/dex/parser/DecodedValue$DecodedArrayValue;", "parser"})
public abstract class DecodedValue {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private DecodedValue() {
    }

    public /* synthetic */ DecodedValue(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/linkedin/dex/parser/DecodedValue$DecodedByte;", "Lcom/linkedin/dex/parser/DecodedValue;", "value", "", "(B)V", "getValue", "()B", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "parser"})
    public static final class DecodedByte
    extends DecodedValue {
        private final byte value;

        public final byte getValue() {
            return this.value;
        }

        public DecodedByte(byte value) {
            super(null);
            this.value = value;
        }

        public final byte component1() {
            return this.value;
        }

        @NotNull
        public final DecodedByte copy(byte value) {
            return new DecodedByte(value);
        }

        public static /* synthetic */ DecodedByte copy$default(DecodedByte decodedByte, byte by, int n, Object object) {
            if ((n & 1) != 0) {
                by = decodedByte.value;
            }
            return decodedByte.copy(by);
        }

        @NotNull
        public String toString() {
            return "DecodedByte(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DecodedByte)) break block3;
                    DecodedByte decodedByte = (DecodedByte)object;
                    if (this.value != decodedByte.value) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/linkedin/dex/parser/DecodedValue$DecodedShort;", "Lcom/linkedin/dex/parser/DecodedValue;", "value", "", "(S)V", "getValue", "()S", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "parser"})
    public static final class DecodedShort
    extends DecodedValue {
        private final short value;

        public final short getValue() {
            return this.value;
        }

        public DecodedShort(short value) {
            super(null);
            this.value = value;
        }

        public final short component1() {
            return this.value;
        }

        @NotNull
        public final DecodedShort copy(short value) {
            return new DecodedShort(value);
        }

        public static /* synthetic */ DecodedShort copy$default(DecodedShort decodedShort, short s, int n, Object object) {
            if ((n & 1) != 0) {
                s = decodedShort.value;
            }
            return decodedShort.copy(s);
        }

        @NotNull
        public String toString() {
            return "DecodedShort(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DecodedShort)) break block3;
                    DecodedShort decodedShort = (DecodedShort)object;
                    if (this.value != decodedShort.value) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/linkedin/dex/parser/DecodedValue$DecodedChar;", "Lcom/linkedin/dex/parser/DecodedValue;", "value", "", "(C)V", "getValue", "()C", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "parser"})
    public static final class DecodedChar
    extends DecodedValue {
        private final char value;

        public final char getValue() {
            return this.value;
        }

        public DecodedChar(char value) {
            super(null);
            this.value = value;
        }

        public final char component1() {
            return this.value;
        }

        @NotNull
        public final DecodedChar copy(char value) {
            return new DecodedChar(value);
        }

        public static /* synthetic */ DecodedChar copy$default(DecodedChar decodedChar, char c, int n, Object object) {
            if ((n & 1) != 0) {
                c = decodedChar.value;
            }
            return decodedChar.copy(c);
        }

        @NotNull
        public String toString() {
            return "DecodedChar(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DecodedChar)) break block3;
                    DecodedChar decodedChar = (DecodedChar)object;
                    if (this.value != decodedChar.value) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/linkedin/dex/parser/DecodedValue$DecodedInt;", "Lcom/linkedin/dex/parser/DecodedValue;", "value", "", "(I)V", "getValue", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "parser"})
    public static final class DecodedInt
    extends DecodedValue {
        private final int value;

        public final int getValue() {
            return this.value;
        }

        public DecodedInt(int value) {
            super(null);
            this.value = value;
        }

        public final int component1() {
            return this.value;
        }

        @NotNull
        public final DecodedInt copy(int value) {
            return new DecodedInt(value);
        }

        public static /* synthetic */ DecodedInt copy$default(DecodedInt decodedInt, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = decodedInt.value;
            }
            return decodedInt.copy(n);
        }

        @NotNull
        public String toString() {
            return "DecodedInt(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DecodedInt)) break block3;
                    DecodedInt decodedInt = (DecodedInt)object;
                    if (this.value != decodedInt.value) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/linkedin/dex/parser/DecodedValue$DecodedLong;", "Lcom/linkedin/dex/parser/DecodedValue;", "value", "", "(J)V", "getValue", "()J", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "parser"})
    public static final class DecodedLong
    extends DecodedValue {
        private final long value;

        public final long getValue() {
            return this.value;
        }

        public DecodedLong(long value) {
            super(null);
            this.value = value;
        }

        public final long component1() {
            return this.value;
        }

        @NotNull
        public final DecodedLong copy(long value) {
            return new DecodedLong(value);
        }

        public static /* synthetic */ DecodedLong copy$default(DecodedLong decodedLong, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = decodedLong.value;
            }
            return decodedLong.copy(l);
        }

        @NotNull
        public String toString() {
            return "DecodedLong(value=" + this.value + ")";
        }

        public int hashCode() {
            long l = this.value;
            return (int)(l ^ l >>> 32);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DecodedLong)) break block3;
                    DecodedLong decodedLong = (DecodedLong)object;
                    if (this.value != decodedLong.value) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/linkedin/dex/parser/DecodedValue$DecodedFloat;", "Lcom/linkedin/dex/parser/DecodedValue;", "value", "", "(F)V", "getValue", "()F", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "parser"})
    public static final class DecodedFloat
    extends DecodedValue {
        private final float value;

        public final float getValue() {
            return this.value;
        }

        public DecodedFloat(float value) {
            super(null);
            this.value = value;
        }

        public final float component1() {
            return this.value;
        }

        @NotNull
        public final DecodedFloat copy(float value) {
            return new DecodedFloat(value);
        }

        public static /* synthetic */ DecodedFloat copy$default(DecodedFloat decodedFloat, float f, int n, Object object) {
            if ((n & 1) != 0) {
                f = decodedFloat.value;
            }
            return decodedFloat.copy(f);
        }

        @NotNull
        public String toString() {
            return "DecodedFloat(value=" + this.value + ")";
        }

        public int hashCode() {
            return Float.floatToIntBits(this.value);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DecodedFloat)) break block3;
                    DecodedFloat decodedFloat = (DecodedFloat)object;
                    if (Float.compare(this.value, decodedFloat.value) != 0) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/linkedin/dex/parser/DecodedValue$DecodedDouble;", "Lcom/linkedin/dex/parser/DecodedValue;", "value", "", "(D)V", "getValue", "()D", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "parser"})
    public static final class DecodedDouble
    extends DecodedValue {
        private final double value;

        public final double getValue() {
            return this.value;
        }

        public DecodedDouble(double value) {
            super(null);
            this.value = value;
        }

        public final double component1() {
            return this.value;
        }

        @NotNull
        public final DecodedDouble copy(double value) {
            return new DecodedDouble(value);
        }

        public static /* synthetic */ DecodedDouble copy$default(DecodedDouble decodedDouble, double d, int n, Object object) {
            if ((n & 1) != 0) {
                d = decodedDouble.value;
            }
            return decodedDouble.copy(d);
        }

        @NotNull
        public String toString() {
            return "DecodedDouble(value=" + this.value + ")";
        }

        public int hashCode() {
            long l = Double.doubleToLongBits(this.value);
            return (int)(l ^ l >>> 32);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DecodedDouble)) break block3;
                    DecodedDouble decodedDouble = (DecodedDouble)object;
                    if (Double.compare(this.value, decodedDouble.value) != 0) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/linkedin/dex/parser/DecodedValue$DecodedString;", "Lcom/linkedin/dex/parser/DecodedValue;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "parser"})
    public static final class DecodedString
    extends DecodedValue {
        @NotNull
        private final String value;

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public DecodedString(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @NotNull
        public final DecodedString copy(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new DecodedString(value);
        }

        public static /* synthetic */ DecodedString copy$default(DecodedString decodedString, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = decodedString.value;
            }
            return decodedString.copy(string);
        }

        @NotNull
        public String toString() {
            return "DecodedString(value=" + this.value + ")";
        }

        public int hashCode() {
            String string = this.value;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DecodedString)) break block3;
                    DecodedString decodedString = (DecodedString)object;
                    if (!Intrinsics.areEqual((Object)this.value, (Object)decodedString.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/linkedin/dex/parser/DecodedValue$DecodedType;", "Lcom/linkedin/dex/parser/DecodedValue;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "parser"})
    public static final class DecodedType
    extends DecodedValue {
        @NotNull
        private final String value;

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public DecodedType(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @NotNull
        public final DecodedType copy(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new DecodedType(value);
        }

        public static /* synthetic */ DecodedType copy$default(DecodedType decodedType, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = decodedType.value;
            }
            return decodedType.copy(string);
        }

        @NotNull
        public String toString() {
            return "DecodedType(value=" + this.value + ")";
        }

        public int hashCode() {
            String string = this.value;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DecodedType)) break block3;
                    DecodedType decodedType = (DecodedType)object;
                    if (!Intrinsics.areEqual((Object)this.value, (Object)decodedType.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/linkedin/dex/parser/DecodedValue$DecodedNull;", "Lcom/linkedin/dex/parser/DecodedValue;", "()V", "parser"})
    public static final class DecodedNull
    extends DecodedValue {
        @NotNull
        public static final DecodedNull INSTANCE;

        private DecodedNull() {
            super(null);
        }

        static {
            DecodedNull decodedNull;
            INSTANCE = decodedNull = new DecodedNull();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/linkedin/dex/parser/DecodedValue$DecodedBoolean;", "Lcom/linkedin/dex/parser/DecodedValue;", "value", "", "(Z)V", "getValue", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "parser"})
    public static final class DecodedBoolean
    extends DecodedValue {
        private final boolean value;

        public final boolean getValue() {
            return this.value;
        }

        public DecodedBoolean(boolean value) {
            super(null);
            this.value = value;
        }

        public final boolean component1() {
            return this.value;
        }

        @NotNull
        public final DecodedBoolean copy(boolean value) {
            return new DecodedBoolean(value);
        }

        public static /* synthetic */ DecodedBoolean copy$default(DecodedBoolean decodedBoolean, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = decodedBoolean.value;
            }
            return decodedBoolean.copy(bl);
        }

        @NotNull
        public String toString() {
            return "DecodedBoolean(value=" + this.value + ")";
        }

        public int hashCode() {
            int n = this.value ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DecodedBoolean)) break block3;
                    DecodedBoolean decodedBoolean = (DecodedBoolean)object;
                    if (this.value != decodedBoolean.value) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/linkedin/dex/parser/DecodedValue$DecodedEnum;", "Lcom/linkedin/dex/parser/DecodedValue;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "parser"})
    public static final class DecodedEnum
    extends DecodedValue {
        @NotNull
        private final String value;

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public DecodedEnum(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @NotNull
        public final DecodedEnum copy(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new DecodedEnum(value);
        }

        public static /* synthetic */ DecodedEnum copy$default(DecodedEnum decodedEnum, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = decodedEnum.value;
            }
            return decodedEnum.copy(string);
        }

        @NotNull
        public String toString() {
            return "DecodedEnum(value=" + this.value + ")";
        }

        public int hashCode() {
            String string = this.value;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DecodedEnum)) break block3;
                    DecodedEnum decodedEnum = (DecodedEnum)object;
                    if (!Intrinsics.areEqual((Object)this.value, (Object)decodedEnum.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/linkedin/dex/parser/DecodedValue$DecodedArrayValue;", "Lcom/linkedin/dex/parser/DecodedValue;", "values", "", "([Lcom/linkedin/dex/parser/DecodedValue;)V", "getValues", "()[Lcom/linkedin/dex/parser/DecodedValue;", "[Lcom/linkedin/dex/parser/DecodedValue;", "component1", "copy", "([Lcom/linkedin/dex/parser/DecodedValue;)Lcom/linkedin/dex/parser/DecodedValue$DecodedArrayValue;", "equals", "", "other", "", "hashCode", "", "toString", "", "parser"})
    public static final class DecodedArrayValue
    extends DecodedValue {
        @NotNull
        private final DecodedValue[] values;

        @NotNull
        public final DecodedValue[] getValues() {
            return this.values;
        }

        public DecodedArrayValue(@NotNull DecodedValue[] values) {
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            super(null);
            this.values = values;
        }

        @NotNull
        public final DecodedValue[] component1() {
            return this.values;
        }

        @NotNull
        public final DecodedArrayValue copy(@NotNull DecodedValue[] values) {
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            return new DecodedArrayValue(values);
        }

        public static /* synthetic */ DecodedArrayValue copy$default(DecodedArrayValue decodedArrayValue, DecodedValue[] decodedValueArray, int n, Object object) {
            if ((n & 1) != 0) {
                decodedValueArray = decodedArrayValue.values;
            }
            return decodedArrayValue.copy(decodedValueArray);
        }

        @NotNull
        public String toString() {
            return "DecodedArrayValue(values=" + Arrays.toString(this.values) + ")";
        }

        public int hashCode() {
            return this.values != null ? Arrays.hashCode(this.values) : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DecodedArrayValue)) break block3;
                    DecodedArrayValue decodedArrayValue = (DecodedArrayValue)object;
                    if (!Intrinsics.areEqual((Object)this.values, (Object)decodedArrayValue.values)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/linkedin/dex/parser/DecodedValue$Companion;", "", "()V", "create", "Lcom/linkedin/dex/parser/DecodedValue;", "dexFile", "Lcom/linkedin/dex/spec/DexFile;", "encodedValue", "Lcom/linkedin/dex/spec/EncodedValue;", "readStringInPosition", "", "position", "", "parser"})
    public static final class Companion {
        private final String readStringInPosition(DexFile dexFile, int position) {
            dexFile.getByteBuffer().position(position);
            Leb128.Companion.readUnsignedLeb128(dexFile.getByteBuffer());
            return ParseUtils.INSTANCE.parseStringBytes(dexFile.getByteBuffer());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DecodedValue create(@NotNull DexFile dexFile, @NotNull EncodedValue encodedValue) {
            Intrinsics.checkNotNullParameter((Object)dexFile, (String)"dexFile");
            Intrinsics.checkNotNullParameter((Object)encodedValue, (String)"encodedValue");
            EncodedValue encodedValue2 = encodedValue;
            if (encodedValue2 instanceof EncodedValue.EncodedByte) {
                return new DecodedByte(((EncodedValue.EncodedByte)encodedValue).getValue());
            }
            if (encodedValue2 instanceof EncodedValue.EncodedShort) {
                return new DecodedShort(((EncodedValue.EncodedShort)encodedValue).getValue());
            }
            if (encodedValue2 instanceof EncodedValue.EncodedChar) {
                return new DecodedChar(((EncodedValue.EncodedChar)encodedValue).getValue());
            }
            if (encodedValue2 instanceof EncodedValue.EncodedInt) {
                return new DecodedInt(((EncodedValue.EncodedInt)encodedValue).getValue());
            }
            if (encodedValue2 instanceof EncodedValue.EncodedLong) {
                return new DecodedLong(((EncodedValue.EncodedLong)encodedValue).getValue());
            }
            if (encodedValue2 instanceof EncodedValue.EncodedFloat) {
                return new DecodedFloat(((EncodedValue.EncodedFloat)encodedValue).getValue());
            }
            if (encodedValue2 instanceof EncodedValue.EncodedDouble) {
                return new DecodedDouble(((EncodedValue.EncodedDouble)encodedValue).getValue());
            }
            if (encodedValue2 instanceof EncodedValue.EncodedString) {
                int position = dexFile.getStringIds()[((EncodedValue.EncodedString)encodedValue).getValue()].getStringDataOff();
                return new DecodedString(this.readStringInPosition(dexFile, position));
            }
            if (encodedValue2 instanceof EncodedValue.EncodedType) {
                int index = dexFile.getTypeIds()[((EncodedValue.EncodedType)encodedValue).getValue()].getDescriptorIdx();
                int position = dexFile.getStringIds()[index].getStringDataOff();
                return new DecodedType(this.readStringInPosition(dexFile, position));
            }
            if (encodedValue2 instanceof EncodedValue.EncodedBoolean) {
                return new DecodedBoolean(((EncodedValue.EncodedBoolean)encodedValue).getValue());
            }
            if (encodedValue2 instanceof EncodedValue.EncodedNull) {
                return DecodedNull.INSTANCE;
            }
            if (encodedValue2 instanceof EncodedValue.EncodedEnum) {
                int index = dexFile.getFieldIds()[((EncodedValue.EncodedEnum)encodedValue).getValue()].getNameIdx();
                int position = dexFile.getStringIds()[index].getStringDataOff();
                return new DecodedEnum(this.readStringInPosition(dexFile, position));
            }
            if (encodedValue2 instanceof EncodedValue.EncodedArrayValue) {
                void $this$toTypedArray$iv;
                Collection<DecodedValue> collection;
                void $this$mapTo$iv$iv;
                Object $this$map$iv = ((EncodedValue.EncodedArrayValue)encodedValue).getValue().getValues();
                boolean $i$f$map = false;
                EncodedValue[] encodedValueArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((EncodedValue[])$this$map$iv).length);
                boolean $i$f$mapTo = false;
                void var9_14 = $this$mapTo$iv$iv;
                int n = ((void)var9_14).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var13_18 = item$iv$iv = var9_14[i];
                    collection = destination$iv$iv;
                    boolean bl = false;
                    DecodedValue decodedValue = Companion.create(dexFile, (EncodedValue)it);
                    collection.add(decodedValue);
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = collection;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                DecodedValue[] decodedValueArray = thisCollection$iv.toArray(new DecodedValue[0]);
                if (decodedValueArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                DecodedValue[] decodedValueArray2 = decodedValueArray;
                return new DecodedArrayValue(decodedValueArray2);
            }
            return DecodedNull.INSTANCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

