/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dex.spec;

import com.linkedin.dex.spec.AnnotationElement;
import com.linkedin.dex.spec.Leb128;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ2\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/linkedin/dex/spec/EncodedAnnotation;", "", "typeIdx", "", "size", "elements", "", "Lcom/linkedin/dex/spec/AnnotationElement;", "(II[Lcom/linkedin/dex/spec/AnnotationElement;)V", "getElements", "()[Lcom/linkedin/dex/spec/AnnotationElement;", "[Lcom/linkedin/dex/spec/AnnotationElement;", "getSize", "()I", "getTypeIdx", "component1", "component2", "component3", "copy", "(II[Lcom/linkedin/dex/spec/AnnotationElement;)Lcom/linkedin/dex/spec/EncodedAnnotation;", "equals", "", "other", "hashCode", "toString", "", "Companion", "parser"})
public final class EncodedAnnotation {
    private final int typeIdx;
    private final int size;
    @NotNull
    private final AnnotationElement[] elements;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final int getTypeIdx() {
        return this.typeIdx;
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final AnnotationElement[] getElements() {
        return this.elements;
    }

    public EncodedAnnotation(int typeIdx, int size, @NotNull AnnotationElement[] elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        this.typeIdx = typeIdx;
        this.size = size;
        this.elements = elements;
    }

    public final int component1() {
        return this.typeIdx;
    }

    public final int component2() {
        return this.size;
    }

    @NotNull
    public final AnnotationElement[] component3() {
        return this.elements;
    }

    @NotNull
    public final EncodedAnnotation copy(int typeIdx, int size, @NotNull AnnotationElement[] elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        return new EncodedAnnotation(typeIdx, size, elements);
    }

    public static /* synthetic */ EncodedAnnotation copy$default(EncodedAnnotation encodedAnnotation, int n, int n2, AnnotationElement[] annotationElementArray, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = encodedAnnotation.typeIdx;
        }
        if ((n3 & 2) != 0) {
            n2 = encodedAnnotation.size;
        }
        if ((n3 & 4) != 0) {
            annotationElementArray = encodedAnnotation.elements;
        }
        return encodedAnnotation.copy(n, n2, annotationElementArray);
    }

    @NotNull
    public String toString() {
        return "EncodedAnnotation(typeIdx=" + this.typeIdx + ", size=" + this.size + ", elements=" + Arrays.toString(this.elements) + ")";
    }

    public int hashCode() {
        return (this.typeIdx * 31 + this.size) * 31 + (this.elements != null ? Arrays.hashCode(this.elements) : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof EncodedAnnotation)) break block3;
                EncodedAnnotation encodedAnnotation = (EncodedAnnotation)object;
                if (this.typeIdx != encodedAnnotation.typeIdx || this.size != encodedAnnotation.size || !Intrinsics.areEqual((Object)this.elements, (Object)encodedAnnotation.elements)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/linkedin/dex/spec/EncodedAnnotation$Companion;", "", "()V", "create", "Lcom/linkedin/dex/spec/EncodedAnnotation;", "byteBuffer", "Ljava/nio/ByteBuffer;", "parser"})
    public static final class Companion {
        @NotNull
        public final EncodedAnnotation create(@NotNull ByteBuffer byteBuffer) {
            Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
            int typeIdx = Leb128.Companion.readUnsignedLeb128(byteBuffer);
            int size = Leb128.Companion.readUnsignedLeb128(byteBuffer);
            AnnotationElement[] annotationElementArray = new AnnotationElement[size];
            int n = 0;
            while (n < size) {
                AnnotationElement annotationElement;
                int n2 = n;
                int n3 = n++;
                AnnotationElement[] annotationElementArray2 = annotationElementArray;
                boolean bl = false;
                annotationElementArray2[n3] = annotationElement = new AnnotationElement(byteBuffer);
            }
            AnnotationElement[] elements = annotationElementArray;
            return new EncodedAnnotation(typeIdx, size, elements);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

