/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dex.spec;

import com.linkedin.dex.spec.Leb128;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/linkedin/dex/spec/EncodedMethod;", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "methodIdxDiff", "", "accessFlags", "codeOff", "(III)V", "getAccessFlags", "()I", "getCodeOff", "getMethodIdxDiff", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "parser"})
public final class EncodedMethod {
    private final int methodIdxDiff;
    private final int accessFlags;
    private final int codeOff;

    public final int getMethodIdxDiff() {
        return this.methodIdxDiff;
    }

    public final int getAccessFlags() {
        return this.accessFlags;
    }

    public final int getCodeOff() {
        return this.codeOff;
    }

    public EncodedMethod(int methodIdxDiff, int accessFlags, int codeOff) {
        this.methodIdxDiff = methodIdxDiff;
        this.accessFlags = accessFlags;
        this.codeOff = codeOff;
    }

    public EncodedMethod(@NotNull ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        this(Leb128.Companion.readUnsignedLeb128(byteBuffer), Leb128.Companion.readUnsignedLeb128(byteBuffer), Leb128.Companion.readUnsignedLeb128(byteBuffer));
    }

    public final int component1() {
        return this.methodIdxDiff;
    }

    public final int component2() {
        return this.accessFlags;
    }

    public final int component3() {
        return this.codeOff;
    }

    @NotNull
    public final EncodedMethod copy(int methodIdxDiff, int accessFlags, int codeOff) {
        return new EncodedMethod(methodIdxDiff, accessFlags, codeOff);
    }

    public static /* synthetic */ EncodedMethod copy$default(EncodedMethod encodedMethod, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = encodedMethod.methodIdxDiff;
        }
        if ((n4 & 2) != 0) {
            n2 = encodedMethod.accessFlags;
        }
        if ((n4 & 4) != 0) {
            n3 = encodedMethod.codeOff;
        }
        return encodedMethod.copy(n, n2, n3);
    }

    @NotNull
    public String toString() {
        return "EncodedMethod(methodIdxDiff=" + this.methodIdxDiff + ", accessFlags=" + this.accessFlags + ", codeOff=" + this.codeOff + ")";
    }

    public int hashCode() {
        return (this.methodIdxDiff * 31 + this.accessFlags) * 31 + this.codeOff;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof EncodedMethod)) break block3;
                EncodedMethod encodedMethod = (EncodedMethod)object;
                if (this.methodIdxDiff != encodedMethod.methodIdxDiff || this.accessFlags != encodedMethod.accessFlags || this.codeOff != encodedMethod.codeOff) break block3;
            }
            return true;
        }
        return false;
    }
}

