/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dex.spec;

import com.linkedin.dex.spec.DexException;
import com.linkedin.dex.spec.EncodedAnnotation;
import com.linkedin.dex.spec.EncodedArray;
import com.linkedin.dex.spec.EncodedValueKt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00032\u00020\u0001:\u0011\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0010\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#\u00a8\u0006$"}, d2={"Lcom/linkedin/dex/spec/EncodedValue;", "", "()V", "Companion", "EncodedAnnotationValue", "EncodedArrayValue", "EncodedBoolean", "EncodedByte", "EncodedChar", "EncodedDouble", "EncodedEnum", "EncodedField", "EncodedFloat", "EncodedInt", "EncodedLong", "EncodedMethod", "EncodedNull", "EncodedShort", "EncodedString", "EncodedType", "Lcom/linkedin/dex/spec/EncodedValue$EncodedByte;", "Lcom/linkedin/dex/spec/EncodedValue$EncodedShort;", "Lcom/linkedin/dex/spec/EncodedValue$EncodedChar;", "Lcom/linkedin/dex/spec/EncodedValue$EncodedInt;", "Lcom/linkedin/dex/spec/EncodedValue$EncodedLong;", "Lcom/linkedin/dex/spec/EncodedValue$EncodedFloat;", "Lcom/linkedin/dex/spec/EncodedValue$EncodedDouble;", "Lcom/linkedin/dex/spec/EncodedValue$EncodedString;", "Lcom/linkedin/dex/spec/EncodedValue$EncodedType;", "Lcom/linkedin/dex/spec/EncodedValue$EncodedField;", "Lcom/linkedin/dex/spec/EncodedValue$EncodedMethod;", "Lcom/linkedin/dex/spec/EncodedValue$EncodedEnum;", "Lcom/linkedin/dex/spec/EncodedValue$EncodedArrayValue;", "Lcom/linkedin/dex/spec/EncodedValue$EncodedAnnotationValue;", "Lcom/linkedin/dex/spec/EncodedValue$EncodedNull;", "Lcom/linkedin/dex/spec/EncodedValue$EncodedBoolean;", "parser"})
public abstract class EncodedValue {
    private static final byte VALUE_BYTE;
    private static final byte VALUE_SHORT;
    private static final byte VALUE_CHAR;
    private static final byte VALUE_INT;
    private static final byte VALUE_LONG;
    private static final byte VALUE_FLOAT;
    private static final byte VALUE_DOUBLE;
    private static final byte VALUE_STRING;
    private static final byte VALUE_TYPE;
    private static final byte VALUE_FIELD;
    private static final byte VALUE_METHOD;
    private static final byte VALUE_ENUM;
    private static final byte VALUE_ARRAY;
    private static final byte VALUE_ANNOTATION;
    private static final byte VALUE_NULL;
    private static final byte VALUE_BOOLEAN;
    @NotNull
    public static final Companion Companion;

    private EncodedValue() {
    }

    static {
        Companion = new Companion(null);
        VALUE_SHORT = (byte)2;
        VALUE_CHAR = (byte)3;
        VALUE_INT = (byte)4;
        VALUE_LONG = (byte)6;
        VALUE_FLOAT = (byte)16;
        VALUE_DOUBLE = (byte)17;
        VALUE_STRING = (byte)23;
        VALUE_TYPE = (byte)24;
        VALUE_FIELD = (byte)25;
        VALUE_METHOD = (byte)26;
        VALUE_ENUM = (byte)27;
        VALUE_ARRAY = (byte)28;
        VALUE_ANNOTATION = (byte)29;
        VALUE_NULL = (byte)30;
        VALUE_BOOLEAN = (byte)31;
    }

    public /* synthetic */ EncodedValue(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/linkedin/dex/spec/EncodedValue$EncodedByte;", "Lcom/linkedin/dex/spec/EncodedValue;", "value", "", "(B)V", "getValue", "()B", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "parser"})
    public static final class EncodedByte
    extends EncodedValue {
        private final byte value;

        public final byte getValue() {
            return this.value;
        }

        public EncodedByte(byte value) {
            super(null);
            this.value = value;
        }

        public final byte component1() {
            return this.value;
        }

        @NotNull
        public final EncodedByte copy(byte value) {
            return new EncodedByte(value);
        }

        public static /* synthetic */ EncodedByte copy$default(EncodedByte encodedByte, byte by, int n, Object object) {
            if ((n & 1) != 0) {
                by = encodedByte.value;
            }
            return encodedByte.copy(by);
        }

        @NotNull
        public String toString() {
            return "EncodedByte(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EncodedByte)) break block3;
                    EncodedByte encodedByte = (EncodedByte)object;
                    if (this.value != encodedByte.value) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/linkedin/dex/spec/EncodedValue$EncodedShort;", "Lcom/linkedin/dex/spec/EncodedValue;", "value", "", "(S)V", "getValue", "()S", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "parser"})
    public static final class EncodedShort
    extends EncodedValue {
        private final short value;

        public final short getValue() {
            return this.value;
        }

        public EncodedShort(short value) {
            super(null);
            this.value = value;
        }

        public final short component1() {
            return this.value;
        }

        @NotNull
        public final EncodedShort copy(short value) {
            return new EncodedShort(value);
        }

        public static /* synthetic */ EncodedShort copy$default(EncodedShort encodedShort, short s, int n, Object object) {
            if ((n & 1) != 0) {
                s = encodedShort.value;
            }
            return encodedShort.copy(s);
        }

        @NotNull
        public String toString() {
            return "EncodedShort(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EncodedShort)) break block3;
                    EncodedShort encodedShort = (EncodedShort)object;
                    if (this.value != encodedShort.value) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/linkedin/dex/spec/EncodedValue$EncodedChar;", "Lcom/linkedin/dex/spec/EncodedValue;", "value", "", "(C)V", "getValue", "()C", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "parser"})
    public static final class EncodedChar
    extends EncodedValue {
        private final char value;

        public final char getValue() {
            return this.value;
        }

        public EncodedChar(char value) {
            super(null);
            this.value = value;
        }

        public final char component1() {
            return this.value;
        }

        @NotNull
        public final EncodedChar copy(char value) {
            return new EncodedChar(value);
        }

        public static /* synthetic */ EncodedChar copy$default(EncodedChar encodedChar, char c, int n, Object object) {
            if ((n & 1) != 0) {
                c = encodedChar.value;
            }
            return encodedChar.copy(c);
        }

        @NotNull
        public String toString() {
            return "EncodedChar(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EncodedChar)) break block3;
                    EncodedChar encodedChar = (EncodedChar)object;
                    if (this.value != encodedChar.value) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/linkedin/dex/spec/EncodedValue$EncodedInt;", "Lcom/linkedin/dex/spec/EncodedValue;", "value", "", "(I)V", "getValue", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "parser"})
    public static final class EncodedInt
    extends EncodedValue {
        private final int value;

        public final int getValue() {
            return this.value;
        }

        public EncodedInt(int value) {
            super(null);
            this.value = value;
        }

        public final int component1() {
            return this.value;
        }

        @NotNull
        public final EncodedInt copy(int value) {
            return new EncodedInt(value);
        }

        public static /* synthetic */ EncodedInt copy$default(EncodedInt encodedInt, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = encodedInt.value;
            }
            return encodedInt.copy(n);
        }

        @NotNull
        public String toString() {
            return "EncodedInt(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EncodedInt)) break block3;
                    EncodedInt encodedInt = (EncodedInt)object;
                    if (this.value != encodedInt.value) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/linkedin/dex/spec/EncodedValue$EncodedLong;", "Lcom/linkedin/dex/spec/EncodedValue;", "value", "", "(J)V", "getValue", "()J", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "parser"})
    public static final class EncodedLong
    extends EncodedValue {
        private final long value;

        public final long getValue() {
            return this.value;
        }

        public EncodedLong(long value) {
            super(null);
            this.value = value;
        }

        public final long component1() {
            return this.value;
        }

        @NotNull
        public final EncodedLong copy(long value) {
            return new EncodedLong(value);
        }

        public static /* synthetic */ EncodedLong copy$default(EncodedLong encodedLong, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = encodedLong.value;
            }
            return encodedLong.copy(l);
        }

        @NotNull
        public String toString() {
            return "EncodedLong(value=" + this.value + ")";
        }

        public int hashCode() {
            long l = this.value;
            return (int)(l ^ l >>> 32);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EncodedLong)) break block3;
                    EncodedLong encodedLong = (EncodedLong)object;
                    if (this.value != encodedLong.value) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/linkedin/dex/spec/EncodedValue$EncodedFloat;", "Lcom/linkedin/dex/spec/EncodedValue;", "value", "", "(F)V", "getValue", "()F", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "parser"})
    public static final class EncodedFloat
    extends EncodedValue {
        private final float value;

        public final float getValue() {
            return this.value;
        }

        public EncodedFloat(float value) {
            super(null);
            this.value = value;
        }

        public final float component1() {
            return this.value;
        }

        @NotNull
        public final EncodedFloat copy(float value) {
            return new EncodedFloat(value);
        }

        public static /* synthetic */ EncodedFloat copy$default(EncodedFloat encodedFloat, float f, int n, Object object) {
            if ((n & 1) != 0) {
                f = encodedFloat.value;
            }
            return encodedFloat.copy(f);
        }

        @NotNull
        public String toString() {
            return "EncodedFloat(value=" + this.value + ")";
        }

        public int hashCode() {
            return Float.floatToIntBits(this.value);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EncodedFloat)) break block3;
                    EncodedFloat encodedFloat = (EncodedFloat)object;
                    if (Float.compare(this.value, encodedFloat.value) != 0) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/linkedin/dex/spec/EncodedValue$EncodedDouble;", "Lcom/linkedin/dex/spec/EncodedValue;", "value", "", "(D)V", "getValue", "()D", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "parser"})
    public static final class EncodedDouble
    extends EncodedValue {
        private final double value;

        public final double getValue() {
            return this.value;
        }

        public EncodedDouble(double value) {
            super(null);
            this.value = value;
        }

        public final double component1() {
            return this.value;
        }

        @NotNull
        public final EncodedDouble copy(double value) {
            return new EncodedDouble(value);
        }

        public static /* synthetic */ EncodedDouble copy$default(EncodedDouble encodedDouble, double d, int n, Object object) {
            if ((n & 1) != 0) {
                d = encodedDouble.value;
            }
            return encodedDouble.copy(d);
        }

        @NotNull
        public String toString() {
            return "EncodedDouble(value=" + this.value + ")";
        }

        public int hashCode() {
            long l = Double.doubleToLongBits(this.value);
            return (int)(l ^ l >>> 32);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EncodedDouble)) break block3;
                    EncodedDouble encodedDouble = (EncodedDouble)object;
                    if (Double.compare(this.value, encodedDouble.value) != 0) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/linkedin/dex/spec/EncodedValue$EncodedString;", "Lcom/linkedin/dex/spec/EncodedValue;", "value", "", "(I)V", "getValue", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "parser"})
    public static final class EncodedString
    extends EncodedValue {
        private final int value;

        public final int getValue() {
            return this.value;
        }

        public EncodedString(int value) {
            super(null);
            this.value = value;
        }

        public final int component1() {
            return this.value;
        }

        @NotNull
        public final EncodedString copy(int value) {
            return new EncodedString(value);
        }

        public static /* synthetic */ EncodedString copy$default(EncodedString encodedString, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = encodedString.value;
            }
            return encodedString.copy(n);
        }

        @NotNull
        public String toString() {
            return "EncodedString(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EncodedString)) break block3;
                    EncodedString encodedString = (EncodedString)object;
                    if (this.value != encodedString.value) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/linkedin/dex/spec/EncodedValue$EncodedType;", "Lcom/linkedin/dex/spec/EncodedValue;", "value", "", "(I)V", "getValue", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "parser"})
    public static final class EncodedType
    extends EncodedValue {
        private final int value;

        public final int getValue() {
            return this.value;
        }

        public EncodedType(int value) {
            super(null);
            this.value = value;
        }

        public final int component1() {
            return this.value;
        }

        @NotNull
        public final EncodedType copy(int value) {
            return new EncodedType(value);
        }

        public static /* synthetic */ EncodedType copy$default(EncodedType encodedType, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = encodedType.value;
            }
            return encodedType.copy(n);
        }

        @NotNull
        public String toString() {
            return "EncodedType(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EncodedType)) break block3;
                    EncodedType encodedType = (EncodedType)object;
                    if (this.value != encodedType.value) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/linkedin/dex/spec/EncodedValue$EncodedField;", "Lcom/linkedin/dex/spec/EncodedValue;", "value", "", "(I)V", "getValue", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "parser"})
    public static final class EncodedField
    extends EncodedValue {
        private final int value;

        public final int getValue() {
            return this.value;
        }

        public EncodedField(int value) {
            super(null);
            this.value = value;
        }

        public final int component1() {
            return this.value;
        }

        @NotNull
        public final EncodedField copy(int value) {
            return new EncodedField(value);
        }

        public static /* synthetic */ EncodedField copy$default(EncodedField encodedField, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = encodedField.value;
            }
            return encodedField.copy(n);
        }

        @NotNull
        public String toString() {
            return "EncodedField(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EncodedField)) break block3;
                    EncodedField encodedField = (EncodedField)object;
                    if (this.value != encodedField.value) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/linkedin/dex/spec/EncodedValue$EncodedMethod;", "Lcom/linkedin/dex/spec/EncodedValue;", "value", "", "(I)V", "getValue", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "parser"})
    public static final class EncodedMethod
    extends EncodedValue {
        private final int value;

        public final int getValue() {
            return this.value;
        }

        public EncodedMethod(int value) {
            super(null);
            this.value = value;
        }

        public final int component1() {
            return this.value;
        }

        @NotNull
        public final EncodedMethod copy(int value) {
            return new EncodedMethod(value);
        }

        public static /* synthetic */ EncodedMethod copy$default(EncodedMethod encodedMethod, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = encodedMethod.value;
            }
            return encodedMethod.copy(n);
        }

        @NotNull
        public String toString() {
            return "EncodedMethod(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EncodedMethod)) break block3;
                    EncodedMethod encodedMethod = (EncodedMethod)object;
                    if (this.value != encodedMethod.value) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/linkedin/dex/spec/EncodedValue$EncodedEnum;", "Lcom/linkedin/dex/spec/EncodedValue;", "value", "", "(I)V", "getValue", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "parser"})
    public static final class EncodedEnum
    extends EncodedValue {
        private final int value;

        public final int getValue() {
            return this.value;
        }

        public EncodedEnum(int value) {
            super(null);
            this.value = value;
        }

        public final int component1() {
            return this.value;
        }

        @NotNull
        public final EncodedEnum copy(int value) {
            return new EncodedEnum(value);
        }

        public static /* synthetic */ EncodedEnum copy$default(EncodedEnum encodedEnum, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = encodedEnum.value;
            }
            return encodedEnum.copy(n);
        }

        @NotNull
        public String toString() {
            return "EncodedEnum(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EncodedEnum)) break block3;
                    EncodedEnum encodedEnum = (EncodedEnum)object;
                    if (this.value != encodedEnum.value) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/linkedin/dex/spec/EncodedValue$EncodedArrayValue;", "Lcom/linkedin/dex/spec/EncodedValue;", "value", "Lcom/linkedin/dex/spec/EncodedArray;", "(Lcom/linkedin/dex/spec/EncodedArray;)V", "getValue", "()Lcom/linkedin/dex/spec/EncodedArray;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "parser"})
    public static final class EncodedArrayValue
    extends EncodedValue {
        @NotNull
        private final EncodedArray value;

        @NotNull
        public final EncodedArray getValue() {
            return this.value;
        }

        public EncodedArrayValue(@NotNull EncodedArray value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final EncodedArray component1() {
            return this.value;
        }

        @NotNull
        public final EncodedArrayValue copy(@NotNull EncodedArray value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new EncodedArrayValue(value);
        }

        public static /* synthetic */ EncodedArrayValue copy$default(EncodedArrayValue encodedArrayValue, EncodedArray encodedArray, int n, Object object) {
            if ((n & 1) != 0) {
                encodedArray = encodedArrayValue.value;
            }
            return encodedArrayValue.copy(encodedArray);
        }

        @NotNull
        public String toString() {
            return "EncodedArrayValue(value=" + this.value + ")";
        }

        public int hashCode() {
            EncodedArray encodedArray = this.value;
            return encodedArray != null ? ((Object)encodedArray).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EncodedArrayValue)) break block3;
                    EncodedArrayValue encodedArrayValue = (EncodedArrayValue)object;
                    if (!Intrinsics.areEqual((Object)this.value, (Object)encodedArrayValue.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/linkedin/dex/spec/EncodedValue$EncodedAnnotationValue;", "Lcom/linkedin/dex/spec/EncodedValue;", "value", "Lcom/linkedin/dex/spec/EncodedAnnotation;", "(Lcom/linkedin/dex/spec/EncodedAnnotation;)V", "getValue", "()Lcom/linkedin/dex/spec/EncodedAnnotation;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "parser"})
    public static final class EncodedAnnotationValue
    extends EncodedValue {
        @NotNull
        private final EncodedAnnotation value;

        @NotNull
        public final EncodedAnnotation getValue() {
            return this.value;
        }

        public EncodedAnnotationValue(@NotNull EncodedAnnotation value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final EncodedAnnotation component1() {
            return this.value;
        }

        @NotNull
        public final EncodedAnnotationValue copy(@NotNull EncodedAnnotation value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new EncodedAnnotationValue(value);
        }

        public static /* synthetic */ EncodedAnnotationValue copy$default(EncodedAnnotationValue encodedAnnotationValue, EncodedAnnotation encodedAnnotation, int n, Object object) {
            if ((n & 1) != 0) {
                encodedAnnotation = encodedAnnotationValue.value;
            }
            return encodedAnnotationValue.copy(encodedAnnotation);
        }

        @NotNull
        public String toString() {
            return "EncodedAnnotationValue(value=" + this.value + ")";
        }

        public int hashCode() {
            EncodedAnnotation encodedAnnotation = this.value;
            return encodedAnnotation != null ? ((Object)encodedAnnotation).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EncodedAnnotationValue)) break block3;
                    EncodedAnnotationValue encodedAnnotationValue = (EncodedAnnotationValue)object;
                    if (!Intrinsics.areEqual((Object)this.value, (Object)encodedAnnotationValue.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/linkedin/dex/spec/EncodedValue$EncodedNull;", "Lcom/linkedin/dex/spec/EncodedValue;", "()V", "parser"})
    public static final class EncodedNull
    extends EncodedValue {
        @NotNull
        public static final EncodedNull INSTANCE;

        private EncodedNull() {
            super(null);
        }

        static {
            EncodedNull encodedNull;
            INSTANCE = encodedNull = new EncodedNull();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/linkedin/dex/spec/EncodedValue$EncodedBoolean;", "Lcom/linkedin/dex/spec/EncodedValue;", "value", "", "(Z)V", "getValue", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "parser"})
    public static final class EncodedBoolean
    extends EncodedValue {
        private final boolean value;

        public final boolean getValue() {
            return this.value;
        }

        public EncodedBoolean(boolean value) {
            super(null);
            this.value = value;
        }

        public final boolean component1() {
            return this.value;
        }

        @NotNull
        public final EncodedBoolean copy(boolean value) {
            return new EncodedBoolean(value);
        }

        public static /* synthetic */ EncodedBoolean copy$default(EncodedBoolean encodedBoolean, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = encodedBoolean.value;
            }
            return encodedBoolean.copy(bl);
        }

        @NotNull
        public String toString() {
            return "EncodedBoolean(value=" + this.value + ")";
        }

        public int hashCode() {
            int n = this.value ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EncodedBoolean)) break block3;
                    EncodedBoolean encodedBoolean = (EncodedBoolean)object;
                    if (this.value != encodedBoolean.value) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J \u0010)\u001a\u00020(2\u0006\u0010'\u001a\u00020(2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0002J \u0010-\u001a\u00020(2\u0006\u0010'\u001a\u00020(2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0002J\u0010\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0014\u0010\u0019\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0014\u0010\u001b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0014\u0010\u001d\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0014\u0010\u001f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0014\u0010!\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0014\u0010#\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0006\u00a8\u00060"}, d2={"Lcom/linkedin/dex/spec/EncodedValue$Companion;", "", "()V", "VALUE_ANNOTATION", "", "getVALUE_ANNOTATION", "()B", "VALUE_ARRAY", "getVALUE_ARRAY", "VALUE_BOOLEAN", "getVALUE_BOOLEAN", "VALUE_BYTE", "getVALUE_BYTE", "VALUE_CHAR", "getVALUE_CHAR", "VALUE_DOUBLE", "getVALUE_DOUBLE", "VALUE_ENUM", "getVALUE_ENUM", "VALUE_FIELD", "getVALUE_FIELD", "VALUE_FLOAT", "getVALUE_FLOAT", "VALUE_INT", "getVALUE_INT", "VALUE_LONG", "getVALUE_LONG", "VALUE_METHOD", "getVALUE_METHOD", "VALUE_NULL", "getVALUE_NULL", "VALUE_SHORT", "getVALUE_SHORT", "VALUE_STRING", "getVALUE_STRING", "VALUE_TYPE", "getVALUE_TYPE", "create", "Lcom/linkedin/dex/spec/EncodedValue;", "byteBuffer", "Ljava/nio/ByteBuffer;", "getPaddedBuffer", "size", "", "fullSize", "getPaddedBufferToTheRight", "sizeOf", "valueArg", "parser"})
    public static final class Companion {
        public final byte getVALUE_BYTE() {
            return VALUE_BYTE;
        }

        public final byte getVALUE_SHORT() {
            return VALUE_SHORT;
        }

        public final byte getVALUE_CHAR() {
            return VALUE_CHAR;
        }

        public final byte getVALUE_INT() {
            return VALUE_INT;
        }

        public final byte getVALUE_LONG() {
            return VALUE_LONG;
        }

        public final byte getVALUE_FLOAT() {
            return VALUE_FLOAT;
        }

        public final byte getVALUE_DOUBLE() {
            return VALUE_DOUBLE;
        }

        public final byte getVALUE_STRING() {
            return VALUE_STRING;
        }

        public final byte getVALUE_TYPE() {
            return VALUE_TYPE;
        }

        public final byte getVALUE_FIELD() {
            return VALUE_FIELD;
        }

        public final byte getVALUE_METHOD() {
            return VALUE_METHOD;
        }

        public final byte getVALUE_ENUM() {
            return VALUE_ENUM;
        }

        public final byte getVALUE_ARRAY() {
            return VALUE_ARRAY;
        }

        public final byte getVALUE_ANNOTATION() {
            return VALUE_ANNOTATION;
        }

        public final byte getVALUE_NULL() {
            return VALUE_NULL;
        }

        public final byte getVALUE_BOOLEAN() {
            return VALUE_BOOLEAN;
        }

        @NotNull
        public final EncodedValue create(@NotNull ByteBuffer byteBuffer) {
            byte valueType;
            Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
            int argAndType = EncodedValueKt.access$toUnsigned8BitInt(byteBuffer.get());
            byte valueArg = (byte)(argAndType >>> 5);
            byte by = valueType = (byte)(argAndType & 0x1F);
            if (by == this.getVALUE_BYTE()) {
                return new EncodedByte(byteBuffer.get());
            }
            if (by == this.getVALUE_SHORT()) {
                return new EncodedShort(this.getPaddedBuffer(byteBuffer, this.sizeOf(valueArg), 2).getShort());
            }
            if (by == this.getVALUE_CHAR()) {
                return new EncodedChar(this.getPaddedBuffer(byteBuffer, this.sizeOf(valueArg), 2).getChar());
            }
            if (by == this.getVALUE_INT()) {
                return new EncodedInt(this.getPaddedBuffer(byteBuffer, this.sizeOf(valueArg), 4).getInt());
            }
            if (by == this.getVALUE_LONG()) {
                return new EncodedLong(this.getPaddedBuffer(byteBuffer, this.sizeOf(valueArg), 8).getLong());
            }
            if (by == this.getVALUE_FLOAT()) {
                return new EncodedFloat(this.getPaddedBufferToTheRight(byteBuffer, this.sizeOf(valueArg), 4).getFloat());
            }
            if (by == this.getVALUE_DOUBLE()) {
                return new EncodedDouble(this.getPaddedBufferToTheRight(byteBuffer, this.sizeOf(valueArg), 8).getDouble());
            }
            if (by == this.getVALUE_STRING()) {
                return new EncodedString(this.getPaddedBuffer(byteBuffer, this.sizeOf(valueArg), 4).getInt());
            }
            if (by == this.getVALUE_TYPE()) {
                return new EncodedType(this.getPaddedBuffer(byteBuffer, this.sizeOf(valueArg), 4).getInt());
            }
            if (by == this.getVALUE_FIELD()) {
                return new EncodedField(this.getPaddedBuffer(byteBuffer, this.sizeOf(valueArg), 4).getInt());
            }
            if (by == this.getVALUE_METHOD()) {
                return new EncodedMethod(this.getPaddedBuffer(byteBuffer, this.sizeOf(valueArg), 4).getInt());
            }
            if (by == this.getVALUE_ENUM()) {
                return new EncodedEnum(this.getPaddedBuffer(byteBuffer, this.sizeOf(valueArg), 4).getInt());
            }
            if (by == this.getVALUE_ARRAY()) {
                return new EncodedArrayValue(EncodedArray.Companion.create(byteBuffer));
            }
            if (by == this.getVALUE_ANNOTATION()) {
                return new EncodedAnnotationValue(EncodedAnnotation.Companion.create(byteBuffer));
            }
            if (by == this.getVALUE_NULL()) {
                return EncodedNull.INSTANCE;
            }
            if (by == this.getVALUE_BOOLEAN()) {
                return new EncodedBoolean(valueArg == 1);
            }
            throw (Throwable)new DexException("Bad value type: " + valueType);
        }

        private final int sizeOf(byte valueArg) {
            return valueArg + 1;
        }

        /*
         * WARNING - void declaration
         */
        private final ByteBuffer getPaddedBuffer(ByteBuffer byteBuffer, int size, int fullSize) {
            ByteBuffer buffer = ByteBuffer.allocate(fullSize);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < size; ++i) {
                buffer.put(byteBuffer.get());
            }
            int n = size + 1;
            int n2 = fullSize;
            if (n <= n2) {
                while (true) {
                    void x;
                    buffer.put((byte)0);
                    if (x == n2) break;
                    ++x;
                }
            }
            buffer.position(0);
            ByteBuffer byteBuffer2 = buffer;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"buffer");
            return byteBuffer2;
        }

        /*
         * WARNING - void declaration
         */
        private final ByteBuffer getPaddedBufferToTheRight(ByteBuffer byteBuffer, int size, int fullSize) {
            ByteBuffer buffer = ByteBuffer.allocate(fullSize);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int n = size + 1;
            int n2 = fullSize;
            if (n <= n2) {
                while (true) {
                    void x;
                    buffer.put((byte)0);
                    if (x == n2) break;
                    ++x;
                }
            }
            for (int i = 0; i < size; ++i) {
                buffer.put(byteBuffer.get());
            }
            buffer.position(0);
            ByteBuffer byteBuffer2 = buffer;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"buffer");
            return byteBuffer2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

