/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.compute;

import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.IntegerMap;
import com.linkedin.data.template.LongMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.feathr.compute.Aggregation;
import com.linkedin.feathr.compute.AnyNode;
import com.linkedin.feathr.compute.AnyNodeArray;
import com.linkedin.feathr.compute.ComputeGraph;
import com.linkedin.feathr.compute.ComputeGraphs;
import com.linkedin.feathr.compute.DataSource;
import com.linkedin.feathr.compute.External;
import com.linkedin.feathr.compute.Lookup;
import com.linkedin.feathr.compute.PegasusUtils;
import com.linkedin.feathr.compute.Transformation;

public class ComputeGraphBuilder {
    IntegerMap _featureNameMap = new IntegerMap();
    LongMap _dataSourceMap = new LongMap();
    AnyNodeArray _nodes = new AnyNodeArray();

    public int addNode(AnyNode node) {
        int newId = this._nodes.size();
        PegasusUtils.setNodeId(node, newId);
        this._nodes.add((DataTemplate)node);
        return newId;
    }

    public DataSource addNewDataSource() {
        return this.addNodeHelper(new DataSource());
    }

    public Transformation addNewTransformation() {
        return this.addNodeHelper(new Transformation());
    }

    public Aggregation addNewAggregation() {
        return this.addNodeHelper(new Aggregation());
    }

    public Lookup addNewLookup() {
        return this.addNodeHelper(new Lookup());
    }

    public External addNewExternal() {
        return this.addNodeHelper(new External());
    }

    public <T extends RecordTemplate> T addNodeHelper(T node) {
        this.addNode(PegasusUtils.wrapAnyNode(node));
        return node;
    }

    public void addFeatureName(String featureName, Integer nodeId) {
        if (nodeId >= this._nodes.size()) {
            throw new IllegalArgumentException("Node id " + nodeId + " is not defined in the graph being built: " + this);
        }
        if (this._featureNameMap.containsKey((Object)featureName)) {
            throw new IllegalArgumentException("Feature " + featureName + " is already defined in the graph being built: " + this);
        }
        this._featureNameMap.put(featureName, (Object)nodeId);
    }

    public int peekNextNodeId() {
        return this._nodes.size();
    }

    public ComputeGraph build() {
        return this.build(new ComputeGraph());
    }

    public ComputeGraph build(ComputeGraph reuse) {
        return this.build(reuse, true);
    }

    ComputeGraph build(ComputeGraph reuse, boolean validate) {
        reuse.setFeatureNames(this._featureNameMap).setNodes(this._nodes);
        if (validate) {
            ComputeGraphs.validate(reuse);
        }
        return reuse;
    }

    public String toString() {
        return "ComputeGraphBuilder{_featureNameMap=" + this._featureNameMap + ", _nodes=" + this._nodes + '}';
    }
}

