/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.compute;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.feathr.compute.AbstractNode;
import com.linkedin.feathr.compute.Aggregation;
import com.linkedin.feathr.compute.AnyNode;
import com.linkedin.feathr.compute.ConcreteKey;
import com.linkedin.feathr.compute.DataSource;
import com.linkedin.feathr.compute.External;
import com.linkedin.feathr.compute.Lookup;
import com.linkedin.feathr.compute.Transformation;

public class PegasusUtils {
    private PegasusUtils() {
    }

    static AnyNode copy(AnyNode node) {
        try {
            return node.copy();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    static AnyNode wrapAnyNode(RecordTemplate node) {
        if (node instanceof Aggregation) {
            return AnyNode.create((Aggregation)((Aggregation)node));
        }
        if (node instanceof DataSource) {
            return AnyNode.create((DataSource)((DataSource)node));
        }
        if (node instanceof Lookup) {
            return AnyNode.create((Lookup)((Lookup)node));
        }
        if (node instanceof Transformation) {
            return AnyNode.create((Transformation)((Transformation)node));
        }
        if (node instanceof External) {
            return AnyNode.create((External)((External)node));
        }
        throw new RuntimeException("Unhandled kind of node: " + node);
    }

    static RecordTemplate unwrapAnyNode(AnyNode anyNode) {
        if (anyNode.isAggregation()) {
            return anyNode.getAggregation();
        }
        if (anyNode.isDataSource()) {
            return anyNode.getDataSource();
        }
        if (anyNode.isLookup()) {
            return anyNode.getLookup();
        }
        if (anyNode.isTransformation()) {
            return anyNode.getTransformation();
        }
        if (anyNode.isExternal()) {
            return anyNode.getExternal();
        }
        throw new RuntimeException("Unhandled kind of AnyNode: " + anyNode);
    }

    static int getNodeId(AnyNode anyNode) {
        return PegasusUtils.abstractNode(anyNode).getId();
    }

    public static int getNodeId(RecordTemplate node) {
        return PegasusUtils.abstractNode(node).getId();
    }

    static void setNodeId(AnyNode node, int id) {
        PegasusUtils.abstractNode(node).setId(id);
    }

    static boolean hasConcreteKey(AnyNode anyNode) {
        return PegasusUtils.abstractNode(anyNode).hasConcreteKey();
    }

    static ConcreteKey getConcreteKey(AnyNode anyNode) {
        return PegasusUtils.abstractNode(anyNode).getConcreteKey();
    }

    static void setConcreteKey(AnyNode anyNode, ConcreteKey concreteKey) {
        PegasusUtils.abstractNode(anyNode).setConcreteKey(concreteKey);
    }

    private static AbstractNode abstractNode(AnyNode anyNode) {
        return new AbstractNode(PegasusUtils.unwrapAnyNode(anyNode).data());
    }

    private static AbstractNode abstractNode(RecordTemplate anyNode) {
        return new AbstractNode(anyNode.data());
    }
}

