/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.compute;

import com.linkedin.data.template.IntegerArray;
import com.linkedin.feathr.compute.Aggregation;
import com.linkedin.feathr.compute.AnyNode;
import com.linkedin.feathr.compute.ComputeGraph;
import com.linkedin.feathr.compute.ComputeGraphBuilder;
import com.linkedin.feathr.compute.ComputeGraphs;
import com.linkedin.feathr.compute.ConcreteKey;
import com.linkedin.feathr.compute.DataSource;
import com.linkedin.feathr.compute.DataSourceType;
import com.linkedin.feathr.compute.External;
import com.linkedin.feathr.compute.KeyReference;
import com.linkedin.feathr.compute.KeyReferenceArray;
import com.linkedin.feathr.compute.Lookup;
import com.linkedin.feathr.compute.NodeReference;
import com.linkedin.feathr.compute.PegasusUtils;
import com.linkedin.feathr.compute.Transformation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Resolver {
    private final ComputeGraph _definitionGraph;

    public Resolver(ComputeGraph graph) {
        ComputeGraphs.ensureNoConcreteKeys(graph);
        this._definitionGraph = ComputeGraphs.validate(graph);
    }

    public static Resolver create(ComputeGraph graph) {
        return new Resolver(graph);
    }

    public ComputeGraph resolveForRequest(List<FeatureRequest> featureRequestList) throws CloneNotSupportedException {
        List<ComputeGraph> graphParts = featureRequestList.stream().map(request -> {
            try {
                return this.resolveForRequest((FeatureRequest)request);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.toList());
        return ComputeGraphs.removeRedundancies(ComputeGraphs.merge(graphParts));
    }

    public ComputeGraph resolveForRequest(FeatureRequest featureRequest) throws CloneNotSupportedException {
        return this.resolveForFeature(featureRequest._featureName, featureRequest._keys, featureRequest._alias);
    }

    public ComputeGraph resolveForFeature(String featureName, List<String> keys, String alias) throws CloneNotSupportedException {
        if (!this._definitionGraph.getFeatureNames().containsKey((Object)featureName)) {
            throw new IllegalArgumentException("Feature graph does not contain requested feature " + featureName);
        }
        if (alias == null) {
            alias = featureName;
        }
        ComputeGraphBuilder builder = new ComputeGraphBuilder();
        ConcreteKey concreteKey = new ConcreteKey().setKey(new IntegerArray());
        keys.forEach(key -> {
            DataSource source = builder.addNewDataSource().setSourceType(DataSourceType.CONTEXT).setExternalSourceRef(key);
            concreteKey.getKey().add((Object)source.getId());
        });
        ConcreteKeyAttacher concreteKeyAttacher = new ConcreteKeyAttacher(builder);
        int newNodeId = concreteKeyAttacher.addNodeAndAttachKey((Integer)this._definitionGraph.getFeatureNames().get((Object)featureName), concreteKey);
        builder.addFeatureName(alias, newNodeId);
        return builder.build();
    }

    private static ConcreteKey transformConcreteKey(ConcreteKey original, KeyReferenceArray keyReference) {
        return new ConcreteKey().setKey(keyReference.stream().map(KeyReference::getPosition).map(arg_0 -> ((IntegerArray)original.getKey()).get(arg_0)).collect(Collectors.toCollection(IntegerArray::new)));
    }

    public static class FeatureRequest {
        private final String _featureName;
        private final List<String> _keys;
        private final Duration _timeDelay;
        private final String _alias;

        public FeatureRequest(String featureName, List<String> keys, Duration timeDelay, String alias) {
            this._featureName = featureName;
            this._keys = keys;
            this._timeDelay = timeDelay;
            this._alias = alias;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FeatureRequest)) {
                return false;
            }
            FeatureRequest that = (FeatureRequest)o;
            return Objects.equals(this._featureName, that._featureName) && Objects.equals(this._keys, that._keys) && Objects.equals(this._alias, that._alias);
        }

        public int hashCode() {
            return Objects.hash(this._featureName, this._keys, this._alias);
        }
    }

    private class ConcreteKeyAttacher {
        private final ComputeGraphBuilder _builder;

        public ConcreteKeyAttacher(ComputeGraphBuilder builder) {
            this._builder = builder;
        }

        int addNodeAndAttachKey(int nodeId, ConcreteKey key) {
            AnyNode node = (AnyNode)Resolver.this._definitionGraph.getNodes().get(nodeId);
            if (PegasusUtils.hasConcreteKey(node)) {
                throw new RuntimeException("Assertion failed. Did not expect to encounter key-annotated node");
            }
            AnyNode newNode = PegasusUtils.copy(node);
            PegasusUtils.setConcreteKey(newNode, key);
            this.attachKeyToDependencies(newNode, key);
            return this._builder.addNode(newNode);
        }

        private void attachKeyToDependencies(AnyNode node, ConcreteKey key) {
            if (node.isAggregation()) {
                this.attachKeyToDependencies(node.getAggregation(), key);
            } else if (node.isDataSource()) {
                this.attachKeyToDependencies(node.getDataSource(), key);
            } else if (node.isLookup()) {
                this.attachKeyToDependencies(node.getLookup(), key);
            } else if (node.isTransformation()) {
                this.attachKeyToDependencies(node.getTransformation(), key);
            } else if (node.isExternal()) {
                this.attachKeyToDependencies(node.getExternal(), key);
            } else {
                throw new RuntimeException("Unhandled kind of AnyNode: " + node);
            }
        }

        private void attachKeyToDependencies(Aggregation node, ConcreteKey key) {
            NodeReference childNodeReference = node.getInput();
            if (((AnyNode)Resolver.this._definitionGraph.getNodes().get(childNodeReference.getId().intValue())).isDataSource()) {
                ArrayList<KeyReference> keyReferenceArray = new ArrayList<KeyReference>();
                for (int i = 0; i < key.getKey().size(); ++i) {
                    keyReferenceArray.add(new KeyReference().setPosition(i));
                }
                KeyReferenceArray keyReferenceArray1 = new KeyReferenceArray(keyReferenceArray);
                childNodeReference.setKeyReference(keyReferenceArray1);
            }
            ConcreteKey childKey = Resolver.transformConcreteKey(key, childNodeReference.getKeyReference());
            int childDefinitionNodeId = childNodeReference.getId();
            int resolvedChildNodeId = this.addNodeAndAttachKey(childDefinitionNodeId, childKey);
            childNodeReference.setId(resolvedChildNodeId);
        }

        private void attachKeyToDependencies(DataSource node, ConcreteKey key) {
            if (node.hasSourceType() && node.getSourceType() == DataSourceType.UPDATE) {
                node.setConcreteKey(key);
            }
        }

        private void attachKeyToDependencies(Lookup node, ConcreteKey inputConcreteKey) {
            ConcreteKey concreteLookupKey = new ConcreteKey().setKey(new IntegerArray());
            IntegerArray concreteKeyClone = new IntegerArray();
            concreteKeyClone.addAll((Collection)inputConcreteKey.getKey());
            ConcreteKey inputConcreteKeyClone = new ConcreteKey().setKey(concreteKeyClone);
            node.getLookupKey().forEach(lookupKeyPart -> {
                if (lookupKeyPart.isKeyReference()) {
                    int relativeKey = lookupKeyPart.getKeyReference().getPosition();
                    concreteLookupKey.getKey().add(inputConcreteKeyClone.getKey().get(relativeKey));
                } else if (lookupKeyPart.isNodeReference()) {
                    NodeReference childNodeReference = lookupKeyPart.getNodeReference();
                    ConcreteKey childConcreteKey = Resolver.transformConcreteKey(inputConcreteKey, childNodeReference.getKeyReference());
                    int childDefinitionNodeId = childNodeReference.getId();
                    int resolvedChildNodeId = 0;
                    resolvedChildNodeId = this.addNodeAndAttachKey(childDefinitionNodeId, childConcreteKey);
                    IntegerArray keysToBeRemoved = childConcreteKey.getKey();
                    inputConcreteKey.getKey().removeAll((Collection)keysToBeRemoved);
                    childNodeReference.setId(resolvedChildNodeId);
                    concreteLookupKey.getKey().add((Object)resolvedChildNodeId);
                } else {
                    throw new RuntimeException("Unhandled kind of LookupKey: " + lookupKeyPart);
                }
            });
            int lookupDefinitionNodeId = node.getLookupNode();
            int resolvedLookupNodeId = this.addNodeAndAttachKey(lookupDefinitionNodeId, new ConcreteKey().setKey(concreteLookupKey.getKey()));
            inputConcreteKey.setKey(concreteKeyClone);
            node.setLookupNode(resolvedLookupNodeId);
        }

        private void attachKeyToDependencies(Transformation node, ConcreteKey key) {
            node.getInputs().forEach(childNodeReference -> {
                if (((AnyNode)Resolver.this._definitionGraph.getNodes().get(childNodeReference.getId().intValue())).isDataSource()) {
                    ArrayList<KeyReference> keyReferenceArray = new ArrayList<KeyReference>();
                    for (int i = 0; i < key.getKey().size(); ++i) {
                        keyReferenceArray.add(new KeyReference().setPosition(i));
                    }
                    KeyReferenceArray keyReferenceArray1 = new KeyReferenceArray(keyReferenceArray);
                    childNodeReference.setKeyReference(keyReferenceArray1);
                }
                ConcreteKey childKey = Resolver.transformConcreteKey(key, childNodeReference.getKeyReference());
                int childDefinitionNodeId = childNodeReference.getId();
                int resolvedChildNodeId = 0;
                resolvedChildNodeId = this.addNodeAndAttachKey(childDefinitionNodeId, childKey);
                childNodeReference.setId(resolvedChildNodeId);
            });
        }

        private void attachKeyToDependencies(External node, ConcreteKey key) {
            throw new RuntimeException("Internal error: Can't link key to external feature node not defined in this graph.");
        }
    }
}

