/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.compute.builder;

import com.google.common.base.Preconditions;
import com.linkedin.feathr.compute.MvelExpression;
import com.linkedin.feathr.compute.OfflineKeyFunction;
import com.linkedin.feathr.compute.SqlExpression;
import com.linkedin.feathr.compute.UserDefinedFunction;
import com.linkedin.feathr.core.config.producer.ExprType;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfig;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfigWithExtractor;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfigWithKey;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfigWithKeyExtractor;
import com.linkedin.feathr.core.config.producer.anchors.TypedKey;
import javax.annotation.Nonnull;

public class AnchorKeyFunctionBuilder {
    AnchorConfig _anchorConfig;

    public AnchorKeyFunctionBuilder(@Nonnull AnchorConfig anchorConfig) {
        Preconditions.checkNotNull((Object)anchorConfig);
        this._anchorConfig = anchorConfig;
    }

    public OfflineKeyFunction.KeyFunction build() {
        if (this._anchorConfig instanceof AnchorConfigWithKey) {
            return this.buildFromAnchorConfigWithKey((AnchorConfigWithKey)this._anchorConfig);
        }
        if (this._anchorConfig instanceof AnchorConfigWithKeyExtractor) {
            return this.buildFromConfigWithKeyExtractor((AnchorConfigWithKeyExtractor)this._anchorConfig);
        }
        if (this._anchorConfig instanceof AnchorConfigWithExtractor) {
            return this.buildFromConfigWithExtractor((AnchorConfigWithExtractor)this._anchorConfig);
        }
        throw new IllegalArgumentException(String.format("Anchor config %s has unsupported type %s", this._anchorConfig, this._anchorConfig.getClass()));
    }

    private OfflineKeyFunction.KeyFunction buildFromAnchorConfigWithKey(AnchorConfigWithKey anchorConfigWithKey) {
        return this.buildFromTypedKey(anchorConfigWithKey.getTypedKey());
    }

    private OfflineKeyFunction.KeyFunction buildFromConfigWithExtractor(AnchorConfigWithExtractor anchorConfigWithExtractor) {
        if (anchorConfigWithExtractor.getTypedKey().isPresent()) {
            return this.buildFromTypedKey((TypedKey)anchorConfigWithExtractor.getTypedKey().get());
        }
        String udfClass = anchorConfigWithExtractor.getKeyExtractor().orElse(anchorConfigWithExtractor.getExtractor());
        UserDefinedFunction userDefinedFunction = new UserDefinedFunction().setClazz(udfClass);
        OfflineKeyFunction.KeyFunction keyFunction = new OfflineKeyFunction.KeyFunction();
        keyFunction.setUserDefinedFunction(userDefinedFunction);
        return keyFunction;
    }

    private OfflineKeyFunction.KeyFunction buildFromTypedKey(TypedKey typedKey) {
        String keyEpr = typedKey.getRawKeyExpr();
        if (typedKey.getKeyExprType() == ExprType.MVEL) {
            MvelExpression mvelExpression = new MvelExpression().setMvel(keyEpr);
            OfflineKeyFunction.KeyFunction keyFunction = new OfflineKeyFunction.KeyFunction();
            keyFunction.setMvelExpression(mvelExpression);
            return keyFunction;
        }
        if (typedKey.getKeyExprType() == ExprType.SQL) {
            SqlExpression sparkSqlExpression = new SqlExpression().setSql(keyEpr);
            OfflineKeyFunction.KeyFunction keyFunction = new OfflineKeyFunction.KeyFunction();
            keyFunction.setSqlExpression(sparkSqlExpression);
            return keyFunction;
        }
        throw new IllegalArgumentException(String.format("Typed key %s has unsupported expression type %s", typedKey, typedKey.getKeyExprType()));
    }

    private OfflineKeyFunction.KeyFunction buildFromConfigWithKeyExtractor(AnchorConfigWithKeyExtractor anchorConfigWithKeyExtractor) {
        String keyExtractor = anchorConfigWithKeyExtractor.getKeyExtractor();
        UserDefinedFunction userDefinedFunction = new UserDefinedFunction().setClazz(keyExtractor);
        OfflineKeyFunction.KeyFunction keyFunction = new OfflineKeyFunction.KeyFunction();
        keyFunction.setUserDefinedFunction(userDefinedFunction);
        return keyFunction;
    }
}

