/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.compute.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.linkedin.feathr.compute.Dimension;
import com.linkedin.feathr.compute.DimensionArray;
import com.linkedin.feathr.compute.DimensionType;
import com.linkedin.feathr.compute.TensorCategory;
import com.linkedin.feathr.compute.ValueType;
import com.linkedin.feathr.compute.builder.TensorFeatureFormatBuilder;
import com.linkedin.feathr.core.config.producer.definitions.FeatureType;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

class FeatureTypeTensorFeatureFormatBuilder
extends TensorFeatureFormatBuilder {
    public static final Set<FeatureType> VALID_FEATURE_TYPES = Sets.immutableEnumSet((Enum)FeatureType.BOOLEAN, (Enum[])new FeatureType[]{FeatureType.NUMERIC, FeatureType.CATEGORICAL, FeatureType.CATEGORICAL_SET, FeatureType.VECTOR, FeatureType.DENSE_VECTOR, FeatureType.TERM_VECTOR});
    private static final int UNKNOWN_DIMENSION_SIZE = -1;
    private FeatureType _featureType;
    private Optional<Integer> _embeddingSize;

    public FeatureTypeTensorFeatureFormatBuilder(@Nonnull FeatureType featureType) {
        Preconditions.checkNotNull((Object)featureType);
        this._featureType = featureType;
        this._embeddingSize = Optional.empty();
    }

    public FeatureTypeTensorFeatureFormatBuilder(@Nonnull FeatureType featureType, int embeddingSize) {
        Preconditions.checkNotNull((Object)featureType);
        this._featureType = featureType;
        this._embeddingSize = Optional.of(embeddingSize);
    }

    @Override
    void validCheck() {
        if (!VALID_FEATURE_TYPES.contains(this._featureType)) {
            throw new IllegalArgumentException(String.format("Invalid feature type %s for TensorFeatureFormat. Valid types are %s", this._featureType, VALID_FEATURE_TYPES));
        }
        if (this._embeddingSize.isPresent() && this._featureType != FeatureType.DENSE_VECTOR) {
            throw new IllegalArgumentException(String.format("Dense vector feature type is expected when embedding size is set. But provided type is %s", this._featureType));
        }
    }

    @Override
    ValueType buildValueType() {
        return ValueType.FLOAT;
    }

    @Override
    DimensionArray buildDimensions() {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        if (this._featureType == FeatureType.NUMERIC || this._featureType == FeatureType.BOOLEAN) {
            return new DimensionArray(dimensions);
        }
        Dimension dimension = new Dimension();
        if (this._embeddingSize.isPresent()) {
            dimension.setShape(this._embeddingSize.get());
        } else {
            dimension.setShape(-1);
        }
        switch (this._featureType) {
            case CATEGORICAL: 
            case CATEGORICAL_SET: 
            case TERM_VECTOR: {
                dimension.setType(DimensionType.STRING);
                break;
            }
            case VECTOR: 
            case DENSE_VECTOR: {
                dimension.setType(DimensionType.INT);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Feature type %s is not supported. Valid types are: %s", this._featureType, VALID_FEATURE_TYPES));
            }
        }
        dimensions.add(dimension);
        return new DimensionArray(dimensions);
    }

    @Override
    TensorCategory buildTensorCategory() {
        switch (this._featureType) {
            case VECTOR: 
            case DENSE_VECTOR: 
            case BOOLEAN: 
            case NUMERIC: {
                return TensorCategory.DENSE;
            }
            case CATEGORICAL: 
            case CATEGORICAL_SET: 
            case TERM_VECTOR: {
                return TensorCategory.SPARSE;
            }
        }
        throw new IllegalArgumentException(String.format("Feature type %s is not supported. Valid types are: %s", this._featureType, VALID_FEATURE_TYPES));
    }
}

