/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.compute.builder;

import com.google.common.base.Preconditions;
import com.linkedin.feathr.compute.FeatureVersion;
import com.linkedin.feathr.compute.builder.DefaultValueBuilder;
import com.linkedin.feathr.compute.builder.FrameFeatureTypeBuilder;
import com.linkedin.feathr.compute.builder.TensorFeatureFormatBuilder;
import com.linkedin.feathr.compute.builder.TensorFeatureFormatBuilderFactory;
import com.linkedin.feathr.core.config.producer.anchors.FeatureConfig;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfig;
import java.util.Optional;
import javax.annotation.Nonnull;

public class FeatureVersionBuilder {
    private final TensorFeatureFormatBuilderFactory _tensorFeatureFormatBuilderFactory;
    private final DefaultValueBuilder _defaultValueBuilder;
    private final FrameFeatureTypeBuilder _featureTypeBuilder;

    public FeatureVersionBuilder(@Nonnull TensorFeatureFormatBuilderFactory tensorFeatureFormatBuilderFactory, @Nonnull DefaultValueBuilder defaultValueBuilder, @Nonnull FrameFeatureTypeBuilder featureTypeBuilder) {
        Preconditions.checkNotNull((Object)tensorFeatureFormatBuilderFactory);
        Preconditions.checkNotNull((Object)defaultValueBuilder);
        Preconditions.checkNotNull((Object)featureTypeBuilder);
        this._tensorFeatureFormatBuilderFactory = tensorFeatureFormatBuilderFactory;
        this._defaultValueBuilder = defaultValueBuilder;
        this._featureTypeBuilder = featureTypeBuilder;
    }

    public FeatureVersion build(@Nonnull FeatureConfig featureConfig) {
        Preconditions.checkNotNull((Object)featureConfig);
        FeatureVersion featureVersion = new FeatureVersion();
        Optional<TensorFeatureFormatBuilder> tensorFeatureFormatBuilder = this._tensorFeatureFormatBuilderFactory.getBuilder(featureConfig);
        tensorFeatureFormatBuilder.ifPresent(builder -> featureVersion.setFormat(builder.build()));
        featureConfig.getFeatureTypeConfig().flatMap(this._featureTypeBuilder::build).ifPresent(arg_0 -> ((FeatureVersion)featureVersion).setType(arg_0));
        Optional defaultValue = featureConfig.getDefaultValue();
        defaultValue.ifPresent(value -> featureVersion.setDefaultValue(this._defaultValueBuilder.build(value)));
        return featureVersion;
    }

    public FeatureVersion build(@Nonnull DerivationConfig derivationConfig) {
        Preconditions.checkNotNull((Object)derivationConfig);
        FeatureVersion featureVersion = new FeatureVersion();
        Optional<TensorFeatureFormatBuilder> tensorFeatureFormatBuilder = this._tensorFeatureFormatBuilderFactory.getBuilder(derivationConfig);
        tensorFeatureFormatBuilder.ifPresent(builder -> featureVersion.setFormat(builder.build()));
        derivationConfig.getFeatureTypeConfig().flatMap(this._featureTypeBuilder::build).ifPresent(arg_0 -> ((FeatureVersion)featureVersion).setType(arg_0));
        return featureVersion;
    }
}

