/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.compute.builder;

import com.google.common.base.Preconditions;
import com.linkedin.feathr.compute.FrameFeatureType;
import com.linkedin.feathr.compute.builder.TensorTypeTensorFeatureFormatBuilder;
import com.linkedin.feathr.core.config.producer.common.FeatureTypeConfig;
import com.linkedin.feathr.core.config.producer.definitions.FeatureType;
import java.util.Optional;
import javax.annotation.Nonnull;

public class FrameFeatureTypeBuilder {
    private static final FrameFeatureTypeBuilder INSTANCE = new FrameFeatureTypeBuilder();

    public static FrameFeatureTypeBuilder getInstance() {
        return INSTANCE;
    }

    private FrameFeatureTypeBuilder() {
    }

    public Optional<FrameFeatureType> build(@Nonnull FeatureTypeConfig featureTypeConfig) {
        Preconditions.checkNotNull((Object)featureTypeConfig);
        Preconditions.checkNotNull((Object)featureTypeConfig.getFeatureType());
        if (featureTypeConfig.getFeatureType() == FeatureType.UNSPECIFIED) {
            throw new IllegalArgumentException("UNSPECIFIED feature type should not be used in feature config");
        }
        FrameFeatureType featureType = TensorTypeTensorFeatureFormatBuilder.VALID_FEATURE_TYPES.contains(featureTypeConfig.getFeatureType()) ? FrameFeatureType.TENSOR : FrameFeatureType.valueOf((String)featureTypeConfig.getFeatureType().toString());
        return Optional.of(featureType);
    }
}

