/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.compute.builder;

import com.google.common.annotations.VisibleForTesting;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.feathr.compute.LateralView;
import com.linkedin.feathr.compute.LateralViewArray;
import com.linkedin.feathr.compute.SqlExpression;
import com.linkedin.feathr.compute.Unit;
import com.linkedin.feathr.compute.Window;
import com.linkedin.feathr.core.config.TimeWindowAggregationType;
import com.linkedin.feathr.core.config.producer.ExprType;
import com.linkedin.feathr.core.config.producer.TypedExpr;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfig;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfigWithKey;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfigWithKeyExtractor;
import com.linkedin.feathr.core.config.producer.anchors.LateralViewParams;
import com.linkedin.feathr.core.config.producer.anchors.TimeWindowFeatureConfig;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class SlidingWindowOperationBuilder<SLIDING_WINDOW_OPERATION extends RecordTemplate> {
    private Optional<String> _filter = Optional.empty();
    private Optional<String> _groupBy = Optional.empty();
    private Optional<Integer> _limit = Optional.empty();
    private Window _window;
    private String _targetColumn;
    private LateralViewArray _lateralViews;
    private TimeWindowAggregationType _timeWindowAggregationType;

    SlidingWindowOperationBuilder() {
    }

    abstract SLIDING_WINDOW_OPERATION buildSlidingWindowOperationObject(String var1, String var2, Integer var3, Window var4, String var5, LateralViewArray var6, TimeWindowAggregationType var7);

    public SLIDING_WINDOW_OPERATION build(TimeWindowFeatureConfig timeWindowFeatureConfig, AnchorConfig anchorConfig) {
        Optional lateralViewParamsOptional;
        this._timeWindowAggregationType = timeWindowFeatureConfig.getAggregation();
        this._filter = timeWindowFeatureConfig.getTypedFilter().map(typedFilter -> {
            if (typedFilter.getExprType() != ExprType.SQL) {
                throw new IllegalArgumentException(String.format("Trying to set filter expr %s with an invalid expression type %s. The only supported type is SQL. Provided feature config is %s", typedFilter.getExpr(), typedFilter.getExprType(), timeWindowFeatureConfig));
            }
            return typedFilter.getExpr();
        });
        this._groupBy = timeWindowFeatureConfig.getGroupBy();
        this._limit = timeWindowFeatureConfig.getLimit();
        this._window = this.buildWindow(timeWindowFeatureConfig.getWindow());
        TypedExpr columnExpr = timeWindowFeatureConfig.getTypedColumnExpr();
        if (columnExpr.getExprType() != ExprType.SQL) {
            throw new IllegalArgumentException(String.format("Trying to set target column expr %s with an invalid expression type %s. The only supported type is SQL. Provided feature config is %s", columnExpr.getExpr(), columnExpr.getExprType(), timeWindowFeatureConfig));
        }
        this._targetColumn = columnExpr.getExpr();
        if (anchorConfig instanceof AnchorConfigWithKey) {
            AnchorConfigWithKey anchorConfigWithKey = (AnchorConfigWithKey)anchorConfig;
            lateralViewParamsOptional = anchorConfigWithKey.getLateralViewParams();
        } else if (anchorConfig instanceof AnchorConfigWithKeyExtractor) {
            AnchorConfigWithKeyExtractor anchorConfigWithKeyExtractor = (AnchorConfigWithKeyExtractor)anchorConfig;
            lateralViewParamsOptional = anchorConfigWithKeyExtractor.getLateralViewParams();
        } else {
            lateralViewParamsOptional = Optional.empty();
        }
        if (lateralViewParamsOptional.isPresent()) {
            this._lateralViews = this.buildLateralViews((LateralViewParams)lateralViewParamsOptional.get());
            if (((LateralViewParams)lateralViewParamsOptional.get()).getFilter().isPresent()) {
                if (this._filter.isPresent()) {
                    throw new IllegalArgumentException(String.format("Filter present in both feature config %s and lateral view %s", timeWindowFeatureConfig, lateralViewParamsOptional.get()));
                }
                this._filter = ((LateralViewParams)lateralViewParamsOptional.get()).getFilter();
            }
        } else {
            this._lateralViews = new LateralViewArray();
        }
        return this.buildSlidingWindowOperationObject(this._filter.orElse(null), this._groupBy.orElse(null), this._limit.orElse(null), this._window, this._targetColumn, this._lateralViews, this._timeWindowAggregationType);
    }

    @VisibleForTesting
    protected Window buildWindow(Duration windowDuration) {
        long size = windowDuration.getSeconds();
        Unit unit = Unit.SECOND;
        if (size > 0L && size % 60L == 0L) {
            unit = Unit.MINUTE;
            if ((size /= 60L) % 60L == 0L) {
                unit = Unit.HOUR;
                if ((size /= 60L) % 24L == 0L) {
                    size /= 24L;
                    unit = Unit.DAY;
                }
            }
        }
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("window size %d too big", size));
        }
        Window window = new Window();
        window.setSize((int)size);
        window.setUnit(unit);
        return window;
    }

    @VisibleForTesting
    protected LateralViewArray buildLateralViews(@Nullable LateralViewParams lateralViewParams) {
        if (lateralViewParams == null) {
            return new LateralViewArray();
        }
        LateralView lateralView = new LateralView();
        lateralView.setVirtualTableAlias(lateralViewParams.getItemAlias());
        LateralView.TableGeneratingFunction tableGeneratingFunction = new LateralView.TableGeneratingFunction();
        SqlExpression sparkSqlExpression = new SqlExpression();
        sparkSqlExpression.setSql(lateralViewParams.getDef());
        tableGeneratingFunction.setSqlExpression(sparkSqlExpression);
        lateralView.setTableGeneratingFunction(tableGeneratingFunction);
        List<LateralView> lateralViews = Collections.singletonList(lateralView);
        return new LateralViewArray(lateralViews);
    }
}

