/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.compute.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.linkedin.feathr.compute.builder.FeatureTypeTensorFeatureFormatBuilder;
import com.linkedin.feathr.compute.builder.TensorFeatureFormatBuilder;
import com.linkedin.feathr.compute.builder.TensorTypeTensorFeatureFormatBuilder;
import com.linkedin.feathr.core.config.producer.anchors.FeatureConfig;
import com.linkedin.feathr.core.config.producer.anchors.TimeWindowFeatureConfig;
import com.linkedin.feathr.core.config.producer.common.FeatureTypeConfig;
import com.linkedin.feathr.core.config.producer.definitions.FeatureType;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfig;
import java.util.Optional;
import javax.annotation.Nonnull;

public class TensorFeatureFormatBuilderFactory {
    public Optional<TensorFeatureFormatBuilder> getBuilder(@Nonnull FeatureConfig featureConfig) {
        Optional embeddingSizeOptional;
        Preconditions.checkNotNull((Object)featureConfig);
        Optional featureTypeConfigOptional = featureConfig.getFeatureTypeConfig();
        Optional optional = embeddingSizeOptional = featureConfig instanceof TimeWindowFeatureConfig ? ((TimeWindowFeatureConfig)featureConfig).getEmbeddingSize() : Optional.empty();
        if (!featureTypeConfigOptional.isPresent()) {
            return embeddingSizeOptional.map(embeddingSize -> new FeatureTypeTensorFeatureFormatBuilder(FeatureType.DENSE_VECTOR, (int)embeddingSize));
        }
        return Optional.ofNullable(this.getBuilder((FeatureTypeConfig)featureTypeConfigOptional.get(), embeddingSizeOptional.orElse(null), featureConfig.toString()));
    }

    public Optional<TensorFeatureFormatBuilder> getBuilder(@Nonnull DerivationConfig derivationConfig) {
        Preconditions.checkNotNull((Object)derivationConfig);
        return derivationConfig.getFeatureTypeConfig().map(featureTypeConfig -> this.getBuilder((FeatureTypeConfig)featureTypeConfig, null, derivationConfig.toString()));
    }

    private TensorFeatureFormatBuilder getBuilder(FeatureTypeConfig featureTypeConfig, Integer embeddingSize, String configRepresentation) {
        Preconditions.checkNotNull((Object)featureTypeConfig);
        Preconditions.checkNotNull((Object)configRepresentation);
        FeatureType featureType = featureTypeConfig.getFeatureType();
        if (FeatureTypeTensorFeatureFormatBuilder.VALID_FEATURE_TYPES.contains(featureType)) {
            return embeddingSize != null ? new FeatureTypeTensorFeatureFormatBuilder(featureType, embeddingSize) : new FeatureTypeTensorFeatureFormatBuilder(featureType);
        }
        if (TensorTypeTensorFeatureFormatBuilder.VALID_FEATURE_TYPES.contains(featureType)) {
            return embeddingSize != null ? new TensorTypeTensorFeatureFormatBuilder(featureTypeConfig, embeddingSize) : new TensorTypeTensorFeatureFormatBuilder(featureTypeConfig);
        }
        if (featureType == FeatureType.TENSOR) {
            return null;
        }
        if (featureType == FeatureType.UNSPECIFIED) {
            throw new IllegalArgumentException("UNSPECIFIED feature type should not be used in config:" + configRepresentation);
        }
        Sets.SetView supportedFeatureTypes = Sets.union(FeatureTypeTensorFeatureFormatBuilder.VALID_FEATURE_TYPES, TensorTypeTensorFeatureFormatBuilder.VALID_FEATURE_TYPES);
        supportedFeatureTypes.add(FeatureType.TENSOR);
        throw new IllegalArgumentException(String.format("Feature type %s is not supported. The config is is %s. Supported feature type are %s", featureType, configRepresentation, supportedFeatureTypes));
    }
}

