/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.compute.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.linkedin.feathr.compute.Dimension;
import com.linkedin.feathr.compute.DimensionArray;
import com.linkedin.feathr.compute.DimensionType;
import com.linkedin.feathr.compute.TensorCategory;
import com.linkedin.feathr.compute.ValueType;
import com.linkedin.feathr.compute.builder.TensorFeatureFormatBuilder;
import com.linkedin.feathr.core.config.producer.common.FeatureTypeConfig;
import com.linkedin.feathr.core.config.producer.definitions.FeatureType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public class TensorTypeTensorFeatureFormatBuilder
extends TensorFeatureFormatBuilder {
    public static final Set<FeatureType> VALID_FEATURE_TYPES = Sets.immutableEnumSet((Enum)FeatureType.DENSE_TENSOR, (Enum[])new FeatureType[]{FeatureType.SPARSE_TENSOR, FeatureType.RAGGED_TENSOR});
    private static final int UNKNOWN_DIMENSION_SIZE = -1;
    private FeatureTypeConfig _featureTypeConfig;
    private Optional<Integer> _embeddingSize;

    public TensorTypeTensorFeatureFormatBuilder(@Nonnull FeatureTypeConfig featureTypeConfig) {
        Preconditions.checkNotNull((Object)featureTypeConfig);
        this._featureTypeConfig = featureTypeConfig;
        this._embeddingSize = Optional.empty();
    }

    public TensorTypeTensorFeatureFormatBuilder(@Nonnull FeatureTypeConfig featureTypeConfig, int embeddingSize) {
        Preconditions.checkNotNull((Object)featureTypeConfig);
        this._featureTypeConfig = featureTypeConfig;
        this._embeddingSize = Optional.ofNullable(embeddingSize);
    }

    @Override
    void validCheck() {
        if (!this._featureTypeConfig.getDimensionTypes().isPresent() && this._featureTypeConfig.getShapes().isPresent()) {
            throw new IllegalArgumentException(String.format("Shapes are provided but Dimensions are not provided in config%s", this._featureTypeConfig));
        }
        if (this._featureTypeConfig.getDimensionTypes().isPresent() && this._featureTypeConfig.getShapes().isPresent() && ((List)this._featureTypeConfig.getDimensionTypes().get()).size() != ((List)this._featureTypeConfig.getShapes().get()).size()) {
            throw new IllegalArgumentException(String.format("The size of dimension types %d and size of shapes %d are unequal in config %s", ((List)this._featureTypeConfig.getDimensionTypes().get()).size(), ((List)this._featureTypeConfig.getShapes().get()).size(), this._featureTypeConfig));
        }
        if (this._featureTypeConfig.getShapes().isPresent() && !((List)this._featureTypeConfig.getShapes().get()).stream().allMatch(shape -> shape > 0 || shape == -1)) {
            throw new IllegalArgumentException(String.format("Shapes should be larger than 0 or -1. Provided shapes: %s", this._featureTypeConfig.getShapes().get()));
        }
        FeatureType featureType = this._featureTypeConfig.getFeatureType();
        if (!VALID_FEATURE_TYPES.contains(featureType)) {
            throw new IllegalArgumentException(String.format("Invalid feature type %s for TensorFeatureFormat in config %s. Valid types are %s", featureType, this._featureTypeConfig, VALID_FEATURE_TYPES));
        }
        if (this._embeddingSize.isPresent()) {
            if (!this._featureTypeConfig.getShapes().isPresent()) {
                throw new IllegalArgumentException(String.format("Shapes are not present while embedding size %d is set", this._embeddingSize.get()));
            }
            if (((List)this._featureTypeConfig.getShapes().get()).size() != 1) {
                throw new IllegalArgumentException(String.format("One dimensional shape is expected when embedding size is set, but %s is provided", this._featureTypeConfig.getShapes().get()));
            }
            if (!((Integer)((List)this._featureTypeConfig.getShapes().get()).get(0)).equals(this._embeddingSize.get())) {
                throw new IllegalArgumentException(String.format("Embedding size %s and shape size %s don't match", this._embeddingSize.get(), ((List)this._featureTypeConfig.getShapes().get()).get(0)));
            }
            if (this._featureTypeConfig.getFeatureType() != FeatureType.DENSE_TENSOR) {
                throw new IllegalArgumentException(String.format("Dense tensor feature type is expected when embedding size is set. But provided type is %s", this._featureTypeConfig.getFeatureType()));
            }
        }
    }

    @Override
    ValueType buildValueType() {
        if (!this._featureTypeConfig.getValType().isPresent()) {
            throw new IllegalArgumentException(String.format("Value type is not specified in feature type config %s. This is required to build TensorFeatureFormat", this._featureTypeConfig));
        }
        return ValueType.valueOf((String)((String)this._featureTypeConfig.getValType().get()).toUpperCase());
    }

    @Override
    DimensionArray buildDimensions() {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        if (this._featureTypeConfig.getDimensionTypes().isPresent()) {
            for (int i = 0; i < ((List)this._featureTypeConfig.getDimensionTypes().get()).size(); ++i) {
                Dimension dimension = new Dimension();
                if (this._featureTypeConfig.getShapes().isPresent()) {
                    dimension.setShape((Integer)((List)this._featureTypeConfig.getShapes().get()).get(i));
                } else {
                    dimension.setShape(-1);
                }
                DimensionType dimensionType = DimensionType.valueOf((String)((String)((List)this._featureTypeConfig.getDimensionTypes().get()).get(i)).toUpperCase());
                dimension.setType(dimensionType);
                dimensions.add(dimension);
            }
        }
        return new DimensionArray(dimensions);
    }

    @Override
    TensorCategory buildTensorCategory() {
        FeatureType featureType = this._featureTypeConfig.getFeatureType();
        switch (featureType) {
            case DENSE_TENSOR: {
                return TensorCategory.DENSE;
            }
            case SPARSE_TENSOR: {
                return TensorCategory.SPARSE;
            }
            case RAGGED_TENSOR: {
                return TensorCategory.RAGGED;
            }
        }
        throw new IllegalArgumentException(String.format("Invalid feature type %s. Valid types are %s", featureType, VALID_FEATURE_TYPES));
    }
}

