/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.compute.builder;

import com.linkedin.data.template.StringMap;
import com.linkedin.feathr.compute.MvelExpression;
import com.linkedin.feathr.compute.SqlExpression;
import com.linkedin.feathr.compute.UserDefinedFunction;
import com.linkedin.feathr.compute.builder.SlidingWindowAggregationBuilder;
import com.linkedin.feathr.core.config.TimeWindowAggregationType;
import com.linkedin.feathr.core.config.producer.ExprType;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfig;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfigWithExtractor;
import com.linkedin.feathr.core.config.producer.anchors.ExpressionBasedFeatureConfig;
import com.linkedin.feathr.core.config.producer.anchors.ExtractorBasedFeatureConfig;
import com.linkedin.feathr.core.config.producer.anchors.FeatureConfig;
import com.linkedin.feathr.core.config.producer.anchors.TimeWindowFeatureConfig;
import javax.annotation.Nonnull;

public class TransformationFunctionExpressionBuilder {
    private final SlidingWindowAggregationBuilder _slidingWindowAggregationBuilder;

    public TransformationFunctionExpressionBuilder(@Nonnull SlidingWindowAggregationBuilder slidingWindowAggregationBuilder) {
        this._slidingWindowAggregationBuilder = slidingWindowAggregationBuilder;
    }

    public Object buildTransformationExpression(FeatureConfig featureConfig, AnchorConfig anchorConfig) {
        if (anchorConfig instanceof AnchorConfigWithExtractor) {
            AnchorConfigWithExtractor anchorConfigWithExtractor = (AnchorConfigWithExtractor)anchorConfig;
            UserDefinedFunction userDefinedFunction = new UserDefinedFunction();
            userDefinedFunction.setClazz(anchorConfigWithExtractor.getExtractor());
            userDefinedFunction.setParameters(new StringMap(featureConfig.getParameters()));
            return userDefinedFunction;
        }
        if (featureConfig instanceof ExpressionBasedFeatureConfig) {
            ExpressionBasedFeatureConfig expressionBasedFeatureConfig = (ExpressionBasedFeatureConfig)featureConfig;
            if (expressionBasedFeatureConfig.getExprType() == ExprType.MVEL) {
                MvelExpression mvelExpression = new MvelExpression();
                mvelExpression.setMvel(expressionBasedFeatureConfig.getFeatureExpr());
                return mvelExpression;
            }
            if (expressionBasedFeatureConfig.getExprType() == ExprType.SQL) {
                SqlExpression sparkSqlExpression = new SqlExpression();
                sparkSqlExpression.setSql(expressionBasedFeatureConfig.getFeatureExpr());
                return sparkSqlExpression;
            }
            throw new IllegalArgumentException(String.format("Expression type %s is unsupported in feature config %s", expressionBasedFeatureConfig.getExprType(), featureConfig));
        }
        if (featureConfig instanceof ExtractorBasedFeatureConfig) {
            ExtractorBasedFeatureConfig extractorBasedFeatureConfig = (ExtractorBasedFeatureConfig)featureConfig;
            MvelExpression mvelExpression = new MvelExpression();
            mvelExpression.setMvel(extractorBasedFeatureConfig.getFeatureName());
            return mvelExpression;
        }
        if (featureConfig instanceof TimeWindowFeatureConfig) {
            TimeWindowFeatureConfig timeWindowFeatureConfig = (TimeWindowFeatureConfig)featureConfig;
            TimeWindowAggregationType timeWindowAggregationType = ((TimeWindowFeatureConfig)featureConfig).getAggregation();
            if (SlidingWindowAggregationBuilder.isSlidingWindowAggregationType(timeWindowAggregationType)) {
                return this._slidingWindowAggregationBuilder.build(timeWindowFeatureConfig, anchorConfig);
            }
            throw new IllegalArgumentException("Unsupported time window aggregation type " + timeWindowAggregationType);
        }
        throw new IllegalArgumentException(String.format("Feature config type %s is not supported in feature config %s", featureConfig.getClass(), featureConfig));
    }
}

