/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.compute.converter;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.StringMap;
import com.linkedin.feathr.compute.Aggregation;
import com.linkedin.feathr.compute.AggregationFunction;
import com.linkedin.feathr.compute.ComputeGraph;
import com.linkedin.feathr.compute.ComputeGraphBuilder;
import com.linkedin.feathr.compute.DataSource;
import com.linkedin.feathr.compute.DataSourceType;
import com.linkedin.feathr.compute.FeatureVersion;
import com.linkedin.feathr.compute.KeyExpressionType;
import com.linkedin.feathr.compute.LateralView;
import com.linkedin.feathr.compute.MvelExpression;
import com.linkedin.feathr.compute.NodeReference;
import com.linkedin.feathr.compute.NodeReferenceArray;
import com.linkedin.feathr.compute.OfflineKeyFunction;
import com.linkedin.feathr.compute.PegasusUtils;
import com.linkedin.feathr.compute.SlidingWindowFeature;
import com.linkedin.feathr.compute.SqlExpression;
import com.linkedin.feathr.compute.TimestampCol;
import com.linkedin.feathr.compute.TransformationFunction;
import com.linkedin.feathr.compute.Unit;
import com.linkedin.feathr.compute.UserDefinedFunction;
import com.linkedin.feathr.compute.Window;
import com.linkedin.feathr.compute.builder.AnchorKeyFunctionBuilder;
import com.linkedin.feathr.compute.builder.DefaultValueBuilder;
import com.linkedin.feathr.compute.builder.FeatureVersionBuilder;
import com.linkedin.feathr.compute.builder.FrameFeatureTypeBuilder;
import com.linkedin.feathr.compute.builder.SlidingWindowAggregationBuilder;
import com.linkedin.feathr.compute.builder.TensorFeatureFormatBuilderFactory;
import com.linkedin.feathr.compute.builder.TransformationFunctionExpressionBuilder;
import com.linkedin.feathr.compute.converter.ConverterUtils;
import com.linkedin.feathr.compute.converter.FeatureDefConfigConverter;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfig;
import com.linkedin.feathr.core.config.producer.anchors.FeatureConfig;
import com.linkedin.feathr.core.config.producer.sources.HdfsConfig;
import com.linkedin.feathr.core.config.producer.sources.HdfsConfigWithRegularData;
import com.linkedin.feathr.core.config.producer.sources.HdfsConfigWithSlidingWindow;
import com.linkedin.feathr.core.config.producer.sources.PassThroughConfig;
import com.linkedin.feathr.core.config.producer.sources.SourceConfig;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class AnchorConfigConverter
implements FeatureDefConfigConverter<AnchorConfig> {
    private final String _passthrough = "passthrough";
    private final String _anchor = "anchor";
    private final String _swa = "_swa";
    private final String _window_unit = "window_unit";
    private final String _lateral_view_expression_ = "lateral_view_expression_";
    private final String _lateral_view_table_alias_ = "lateral_view_table_alias_";
    private final String _group_by_expression = "group_by_expression";
    private final String _filter_expression = "filter_expression";
    private final String _max_number_groups = "max_number_groups";
    private final String _expression = "expression";
    private final String _class = "class";
    private final String _userParam_ = "userParam_";

    AnchorConfigConverter() {
    }

    @Override
    public ComputeGraph convert(String configElementName, AnchorConfig configObject, Map<String, SourceConfig> sourceMap) {
        KeyExpressionType keyExpressionType;
        String keyExpression;
        ComputeGraphBuilder graphBuilder = new ComputeGraphBuilder();
        OfflineKeyFunction.KeyFunction offlineKeyFunction = new AnchorKeyFunctionBuilder(configObject).build();
        if (offlineKeyFunction.isMvelExpression()) {
            keyExpression = offlineKeyFunction.getMvelExpression().getMvel();
            keyExpressionType = KeyExpressionType.MVEL;
        } else if (offlineKeyFunction.isSqlExpression()) {
            keyExpression = offlineKeyFunction.getSqlExpression().getSql();
            keyExpressionType = KeyExpressionType.SQL;
        } else if (offlineKeyFunction.isUserDefinedFunction()) {
            keyExpression = offlineKeyFunction.getUserDefinedFunction().getClazz();
            keyExpressionType = KeyExpressionType.UDF;
        } else {
            throw new RuntimeException("Unknown key type found in " + configElementName);
        }
        String featureType = this.getTypeOfFeature(sourceMap, configObject);
        DataSource dataSource = this.buildDataSource(graphBuilder, configObject, keyExpressionType, keyExpression, sourceMap, featureType);
        NodeReference referenceToSource = ConverterUtils.makeNodeReferenceWithSimpleKeyReference(dataSource.getId(), 1);
        configObject.getFeatures().forEach((featureName, featureConfig) -> {
            Aggregation operatorNode;
            TransformationFunctionExpressionBuilder transformationFunctionExpressionBuilder = new TransformationFunctionExpressionBuilder(SlidingWindowAggregationBuilder.getInstance());
            Object expression = transformationFunctionExpressionBuilder.buildTransformationExpression((FeatureConfig)featureConfig, configObject);
            RecordTemplate operatorReference = this.getOperator(expression, featureType);
            FeatureVersionBuilder featureVersionBuilder = new FeatureVersionBuilder(new TensorFeatureFormatBuilderFactory(), DefaultValueBuilder.getInstance(), FrameFeatureTypeBuilder.getInstance());
            FeatureVersion featureVersion = featureVersionBuilder.build((FeatureConfig)featureConfig);
            if (operatorReference instanceof AggregationFunction) {
                operatorNode = graphBuilder.addNewAggregation().setFunction((AggregationFunction)operatorReference).setInput(referenceToSource).setFeatureName(featureName).setFeatureVersion(featureVersion);
            } else if (operatorReference instanceof TransformationFunction) {
                operatorNode = graphBuilder.addNewTransformation().setFunction((TransformationFunction)operatorReference).setInputs(new NodeReferenceArray(Collections.singleton(referenceToSource))).setFeatureName(featureName).setFeatureVersion(featureVersion);
            } else {
                throw new RuntimeException("Unexpected operator reference type " + operatorReference.getClass() + " - data: " + operatorReference);
            }
            graphBuilder.addFeatureName((String)featureName, PegasusUtils.getNodeId((RecordTemplate)operatorNode));
        });
        return graphBuilder.build();
    }

    private RecordTemplate getOperator(Object expression, String finalFeatureType) {
        AggregationFunction operatorReference;
        String operator = null;
        if (expression instanceof MvelExpression) {
            if (Objects.equals(finalFeatureType, "anchor")) {
                operator = "feathr:anchor_mvel:0";
            } else if (Objects.equals(finalFeatureType, "passthrough")) {
                operator = "feathr:passthrough_mvel:0";
            }
            operatorReference = this.makeTransformationFunction((MvelExpression)expression, operator);
        } else if (expression instanceof SlidingWindowFeature) {
            operatorReference = this.makeAggregationFunction((SlidingWindowFeature)expression);
        } else if (expression instanceof SqlExpression) {
            if (Objects.equals(finalFeatureType, "anchor")) {
                operator = "feathr:anchor_spark_sql_feature_extractor:0";
            } else if (Objects.equals(finalFeatureType, "passthrough")) {
                operator = "feathr:passthrough_spark_sql_feature_extractor:0";
            }
            operatorReference = this.makeTransformationFunction((SqlExpression)expression, operator);
        } else if (expression instanceof UserDefinedFunction) {
            if (Objects.equals(finalFeatureType, "anchor")) {
                operator = "feathr:anchor_java_udf_feature_extractor:0";
            } else if (Objects.equals(finalFeatureType, "passthrough")) {
                operator = "feathr:passthrough_java_udf_feature_extractor:0";
            }
            operatorReference = this.makeTransformationFunction((UserDefinedFunction)expression, operator);
        } else {
            throw new RuntimeException("No known way to handle " + expression);
        }
        return operatorReference;
    }

    private String getTypeOfFeature(Map<String, SourceConfig> sourceMap, AnchorConfig configObject) {
        HdfsConfigWithRegularData sourceConfig;
        String swa;
        String featureType = sourceMap.containsKey(configObject.getSource()) && sourceMap.get(configObject.getSource()).getClass() == PassThroughConfig.class ? "passthrough" : (sourceMap.containsKey(configObject.getSource()) && sourceMap.get(configObject.getSource()).getClass() == HdfsConfigWithSlidingWindow.class ? (swa = "_swa") : (sourceMap.containsKey(configObject.getSource()) ? ((sourceConfig = (HdfsConfigWithRegularData)sourceMap.get(configObject.getSource())).getTimePartitionPattern().isPresent() ? "_swa" : "anchor") : "anchor"));
        return featureType;
    }

    private DataSource buildDataSource(ComputeGraphBuilder graphBuilder, AnchorConfig configObject, KeyExpressionType keyExpressionType, String keyExpression, Map<String, SourceConfig> sourceMap, String featureType) {
        DataSource dataSourceNode = null;
        if (sourceMap.containsKey(configObject.getSource())) {
            if (Objects.equals(featureType, "anchor")) {
                HdfsConfigWithRegularData sourceConfig = (HdfsConfigWithRegularData)sourceMap.get(configObject.getSource());
                String sourcePath = sourceConfig.getPath();
                dataSourceNode = graphBuilder.addNewDataSource().setExternalSourceRef(sourcePath).setSourceType(DataSourceType.UPDATE).setKeyExpression(keyExpression).setKeyExpressionType(keyExpressionType);
            } else if (Objects.equals(featureType, "_swa")) {
                HdfsConfigWithSlidingWindow swaConfig;
                HdfsConfig sourceConfig = (HdfsConfig)sourceMap.get(configObject.getSource());
                String sourcePath = sourceConfig.getPath();
                dataSourceNode = graphBuilder.addNewDataSource().setExternalSourceRef(sourcePath).setSourceType(DataSourceType.EVENT).setKeyExpression(keyExpression).setKeyExpressionType(keyExpressionType);
                String filePartitionFormat = null;
                if (sourceConfig.getTimePartitionPattern().isPresent()) {
                    filePartitionFormat = (String)sourceConfig.getTimePartitionPattern().get();
                }
                TimestampCol timestampCol = null;
                if (sourceConfig.getClass() == HdfsConfigWithSlidingWindow.class && (swaConfig = (HdfsConfigWithSlidingWindow)sourceConfig).getSwaConfig().getTimeWindowParams() != null) {
                    String timestampColFormat = swaConfig.getSwaConfig().getTimeWindowParams().getTimestampFormat();
                    String timestampColExpr = swaConfig.getSwaConfig().getTimeWindowParams().getTimestampField();
                    timestampCol = new TimestampCol().setExpression(timestampColExpr).setFormat(timestampColFormat);
                }
                if (filePartitionFormat != null && timestampCol != null) {
                    dataSourceNode.setSourceType(DataSourceType.EVENT).setFilePartitionFormat(filePartitionFormat).setTimestampColumnInfo(timestampCol);
                } else if (timestampCol != null) {
                    dataSourceNode.setSourceType(DataSourceType.EVENT).setTimestampColumnInfo(timestampCol);
                } else {
                    dataSourceNode.setSourceType(DataSourceType.EVENT).setFilePartitionFormat(filePartitionFormat);
                }
            } else if (Objects.equals(featureType, "passthrough")) {
                dataSourceNode = graphBuilder.addNewDataSource().setSourceType(DataSourceType.CONTEXT).setKeyExpression(keyExpression).setKeyExpressionType(keyExpressionType);
            }
        } else {
            String sourcePath = configObject.getSource();
            dataSourceNode = graphBuilder.addNewDataSource().setExternalSourceRef(sourcePath).setSourceType(DataSourceType.UPDATE).setKeyExpression(keyExpression).setKeyExpressionType(keyExpressionType);
        }
        return dataSourceNode;
    }

    private AggregationFunction makeAggregationFunction(SlidingWindowFeature input) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        String target_column = "target_column";
        parameterMap.put(target_column, input.getTargetColumn().getSqlExpression().getSql());
        String aggregation_type = "aggregation_type";
        parameterMap.put(aggregation_type, input.getAggregationType().name());
        Duration window = this.convert(input.getWindow());
        String window_size = "window_size";
        parameterMap.put(window_size, window.toString());
        parameterMap.put("window_unit", input.getWindow().getUnit().name());
        for (int i = 0; i < input.getLateralViews().size(); ++i) {
            parameterMap.put("lateral_view_expression_" + i, ((LateralView)input.getLateralViews().get(i)).getTableGeneratingFunction().getSqlExpression().getSql());
            parameterMap.put("lateral_view_table_alias_" + i, ((LateralView)input.getLateralViews().get(i)).getVirtualTableAlias());
        }
        if (input.hasFilter()) {
            parameterMap.put("filter_expression", Objects.requireNonNull(input.getFilter()).getSqlExpression().getSql());
        }
        if (input.hasGroupBy()) {
            parameterMap.put("group_by_expression", Objects.requireNonNull(input.getGroupBy()).getSqlExpression().getSql());
        }
        if (input.hasLimit()) {
            parameterMap.put("max_number_groups", Objects.requireNonNull(input.getLimit()).toString());
        }
        return new AggregationFunction().setOperator("feathr:sliding_window_aggregation:0").setParameters(new StringMap(parameterMap));
    }

    private TransformationFunction makeTransformationFunction(MvelExpression input, String operator) {
        return new TransformationFunction().setOperator(operator).setParameters(new StringMap(Collections.singletonMap("expression", input.getMvel())));
    }

    private TransformationFunction makeTransformationFunction(SqlExpression input, String operator) {
        return new TransformationFunction().setOperator(operator).setParameters(new StringMap(Collections.singletonMap("expression", input.getSql())));
    }

    private TransformationFunction makeTransformationFunction(UserDefinedFunction input, String operator) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("class", input.getClazz());
        input.getParameters().forEach((userParamName, userParamValue) -> parameterMap.put("userParam_" + userParamName, (String)userParamValue));
        return new TransformationFunction().setOperator(operator).setParameters(new StringMap(parameterMap));
    }

    private Duration convert(Window frWindow) {
        int size = frWindow.getSize();
        if (frWindow.getUnit() == Unit.DAY) {
            return Duration.ofDays(size);
        }
        if (frWindow.getUnit() == Unit.HOUR) {
            return Duration.ofHours(size);
        }
        if (frWindow.getUnit() == Unit.MINUTE) {
            return Duration.ofMinutes(size);
        }
        if (frWindow.getUnit() == Unit.SECOND) {
            return Duration.ofSeconds(size);
        }
        throw new RuntimeException("'We only support day, hour, minute, and second time units for window field. The correct example \" +\n            \"can be '1d'(1 day) or '2h'(2 hour) or '3m'(3 minute) or '4s'(4 second) ");
    }
}

