/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.compute.converter;

import com.linkedin.data.template.StringMap;
import com.linkedin.feathr.compute.ComputeGraph;
import com.linkedin.feathr.compute.ComputeGraphBuilder;
import com.linkedin.feathr.compute.External;
import com.linkedin.feathr.compute.FeatureVersion;
import com.linkedin.feathr.compute.KeyReference;
import com.linkedin.feathr.compute.KeyReferenceArray;
import com.linkedin.feathr.compute.NodeReference;
import com.linkedin.feathr.compute.NodeReferenceArray;
import com.linkedin.feathr.compute.Transformation;
import com.linkedin.feathr.compute.TransformationFunction;
import com.linkedin.feathr.compute.builder.DefaultValueBuilder;
import com.linkedin.feathr.compute.builder.FeatureVersionBuilder;
import com.linkedin.feathr.compute.builder.FrameFeatureTypeBuilder;
import com.linkedin.feathr.compute.builder.TensorFeatureFormatBuilderFactory;
import com.linkedin.feathr.compute.converter.FeatureDefConfigConverter;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfig;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfigWithExpr;
import com.linkedin.feathr.core.config.producer.derivations.KeyedFeature;
import com.linkedin.feathr.core.config.producer.sources.SourceConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

class DerivationConfigWithExprConverter
implements FeatureDefConfigConverter<DerivationConfigWithExpr> {
    DerivationConfigWithExprConverter() {
    }

    @Override
    public ComputeGraph convert(String configElementName, DerivationConfigWithExpr configObject, Map<String, SourceConfig> sourceMap) {
        ComputeGraphBuilder graphBuilder = new ComputeGraphBuilder();
        List entityParameters = configObject.getKeys();
        HashMap<String, External> externalFeatureNodes = new HashMap<String, External>();
        HashSet<String> uniqueValues = new HashSet<String>();
        for (Map.Entry input : configObject.getInputs().entrySet()) {
            String featureName = ((KeyedFeature)input.getValue()).getFeature();
            if (!uniqueValues.add(featureName) || externalFeatureNodes.put(featureName, graphBuilder.addNewExternal().setName(featureName)) == null) continue;
            throw new IllegalStateException("Duplicate key found in " + configElementName);
        }
        NodeReferenceArray inputs = configObject.getInputs().entrySet().stream().map(mapEntry -> {
            String inputFeatureName = ((KeyedFeature)mapEntry.getValue()).getFeature();
            List entityArgs = ((KeyedFeature)mapEntry.getValue()).getKey();
            KeyReferenceArray keyReferenceArray = entityArgs.stream().map(entityParameters::indexOf).map(position -> new KeyReference().setPosition(position)).collect(Collectors.toCollection(KeyReferenceArray::new));
            int inputNodeId = ((External)externalFeatureNodes.get(inputFeatureName)).getId();
            if (!Objects.equals(mapEntry.getKey(), "")) {
                ArrayList<KeyReference> regularKeyReferenceArray = new ArrayList<KeyReference>();
                for (int i = 0; i < entityArgs.size(); ++i) {
                    regularKeyReferenceArray.add(new KeyReference().setPosition(i));
                }
                KeyReferenceArray simpleKeyReferenceArray = new KeyReferenceArray(regularKeyReferenceArray);
                NodeReference inputNodeReference = new NodeReference().setId(inputNodeId).setKeyReference(simpleKeyReferenceArray);
                TransformationFunction featureAliasFunction = new TransformationFunction().setOperator("feathr:feature_alias:0");
                Transformation transformation = graphBuilder.addNewTransformation().setInputs(new NodeReferenceArray(Collections.singleton(inputNodeReference))).setFunction(featureAliasFunction).setFeatureVersion(new FeatureVersion()).setFeatureName((String)mapEntry.getKey());
                inputNodeId = transformation.getId();
            }
            return new NodeReference().setId(inputNodeId).setKeyReference(keyReferenceArray);
        }).collect(Collectors.toCollection(NodeReferenceArray::new));
        ArrayList inputParameterNames = new ArrayList(configObject.getInputs().keySet());
        TransformationFunction transformationFunction = new TransformationFunction().setOperator("feathr:extract_from_tuple:0").setParameters(new StringMap(Collections.singletonMap("expression", configObject.getTypedDefinition().getExpr())));
        transformationFunction.getParameters().put("parameterNames", (Object)String.join((CharSequence)",", inputParameterNames));
        FeatureVersionBuilder featureVersionBuilder = new FeatureVersionBuilder(new TensorFeatureFormatBuilderFactory(), DefaultValueBuilder.getInstance(), FrameFeatureTypeBuilder.getInstance());
        FeatureVersion featureVersion = featureVersionBuilder.build((DerivationConfig)configObject);
        Transformation transformation = graphBuilder.addNewTransformation().setInputs(inputs).setFunction(transformationFunction).setFeatureName(configElementName).setFeatureVersion(featureVersion);
        graphBuilder.addFeatureName(configElementName, transformation.getId());
        return graphBuilder.build();
    }
}

