/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.compute.converter;

import com.linkedin.feathr.compute.ComputeGraph;
import com.linkedin.feathr.compute.ComputeGraphs;
import com.linkedin.feathr.compute.converter.AnchorConfigConverter;
import com.linkedin.feathr.compute.converter.DerivationConfigWithExprConverter;
import com.linkedin.feathr.compute.converter.DerivationConfigWithExtractorConverter;
import com.linkedin.feathr.compute.converter.FeatureDefConfigConverter;
import com.linkedin.feathr.compute.converter.SequentialJoinConfigConverter;
import com.linkedin.feathr.compute.converter.SimpleDerivationConfigConverter;
import com.linkedin.feathr.core.config.producer.FeatureDefConfig;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfigWithExtractor;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfigWithKey;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfigWithKeyExtractor;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfigWithOnlyMvel;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfigWithExpr;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfigWithExtractor;
import com.linkedin.feathr.core.config.producer.derivations.SequentialJoinConfig;
import com.linkedin.feathr.core.config.producer.derivations.SimpleDerivationConfig;
import com.linkedin.feathr.core.config.producer.sources.SourceConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FeatureDefinitionsConverter {
    Map<String, SourceConfig> sourcesMap = new HashMap<String, SourceConfig>();
    private final Map<Class<?>, FeatureDefConfigConverter<?>> _configClassConverterMap = new HashMap();

    public FeatureDefinitionsConverter() {
        this.registerConverter(AnchorConfigWithExtractor.class, new AnchorConfigConverter());
        this.registerConverter(AnchorConfigWithKey.class, new AnchorConfigConverter());
        this.registerConverter(AnchorConfigWithKeyExtractor.class, new AnchorConfigConverter());
        this.registerConverter(AnchorConfigWithOnlyMvel.class, new AnchorConfigConverter());
        this.registerConverter(DerivationConfigWithExpr.class, new DerivationConfigWithExprConverter());
        this.registerConverter(DerivationConfigWithExtractor.class, new DerivationConfigWithExtractorConverter());
        this.registerConverter(SimpleDerivationConfig.class, new SimpleDerivationConfigConverter());
        this.registerConverter(SequentialJoinConfig.class, new SequentialJoinConfigConverter());
    }

    public ComputeGraph convert(FeatureDefConfig featureDefinitions) throws CloneNotSupportedException {
        ArrayList<ComputeGraph> graphParts = new ArrayList<ComputeGraph>();
        featureDefinitions.getSourcesConfig().map(sourcesConfig -> sourcesConfig.getSources().entrySet()).orElse(Collections.emptySet()).forEach(entry -> this.sourcesMap.put((String)entry.getKey(), (SourceConfig)entry.getValue()));
        featureDefinitions.getAnchorsConfig().map(anchorsConfig -> anchorsConfig.getAnchors().entrySet()).orElse(Collections.emptySet()).stream().map(entry -> this.convert((String)entry.getKey(), entry.getValue(), this.sourcesMap)).forEach(graphParts::add);
        featureDefinitions.getDerivationsConfig().map(derivationsConfig -> derivationsConfig.getDerivations().entrySet()).orElse(Collections.emptySet()).stream().map(entry -> this.convert((String)entry.getKey(), entry.getValue(), this.sourcesMap)).forEach(graphParts::add);
        return ComputeGraphs.removeRedundancies(ComputeGraphs.merge(graphParts));
    }

    private <T> void registerConverter(Class<T> clazz, FeatureDefConfigConverter<?> converter) {
        this._configClassConverterMap.put(clazz, converter);
    }

    private <T> FeatureDefConfigConverter<T> getConverter(T configObject) {
        return this._configClassConverterMap.get(configObject.getClass());
    }

    private <T> ComputeGraph convert(String name, T config, Map<String, SourceConfig> sourcesMap) {
        FeatureDefConfigConverter<T> converter = this.getConverter(config);
        if (converter != null) {
            return converter.convert(name, config, sourcesMap);
        }
        throw new RuntimeException("Unhandled config class: " + name + ": " + config);
    }
}

