/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.compute.converter;

import com.linkedin.data.template.StringMap;
import com.linkedin.feathr.compute.ComputeGraph;
import com.linkedin.feathr.compute.ComputeGraphBuilder;
import com.linkedin.feathr.compute.External;
import com.linkedin.feathr.compute.FeatureVersion;
import com.linkedin.feathr.compute.KeyReference;
import com.linkedin.feathr.compute.KeyReferenceArray;
import com.linkedin.feathr.compute.Lookup;
import com.linkedin.feathr.compute.MvelExpression;
import com.linkedin.feathr.compute.NodeReference;
import com.linkedin.feathr.compute.NodeReferenceArray;
import com.linkedin.feathr.compute.Transformation;
import com.linkedin.feathr.compute.TransformationFunction;
import com.linkedin.feathr.compute.builder.DefaultValueBuilder;
import com.linkedin.feathr.compute.builder.FeatureVersionBuilder;
import com.linkedin.feathr.compute.builder.FrameFeatureTypeBuilder;
import com.linkedin.feathr.compute.builder.TensorFeatureFormatBuilderFactory;
import com.linkedin.feathr.compute.converter.FeatureDefConfigConverter;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfig;
import com.linkedin.feathr.core.config.producer.derivations.SequentialJoinConfig;
import com.linkedin.feathr.core.config.producer.sources.SourceConfig;
import com.linkedin.feathr.core.utils.MvelInputsResolver;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class SequentialJoinConfigConverter
implements FeatureDefConfigConverter<SequentialJoinConfig> {
    SequentialJoinConfigConverter() {
    }

    @Override
    public ComputeGraph convert(String configElementName, SequentialJoinConfig configObject, Map<String, SourceConfig> sourceMap) {
        Lookup.LookupKey lookupKey;
        ComputeGraphBuilder graphBuilder = new ComputeGraphBuilder();
        String baseFeatureName = configObject.getBase().getFeature();
        List baseFeatureKeys = configObject.getBase().getKey();
        List entityParameters = configObject.getKeys();
        External baseExternalFeatureNode = graphBuilder.addNewExternal().setName(baseFeatureName);
        KeyReferenceArray keyReferenceArray = baseFeatureKeys.stream().map(entityParameters::indexOf).map(position -> new KeyReference().setPosition(position)).collect(Collectors.toCollection(KeyReferenceArray::new));
        int nodeId = baseExternalFeatureNode.getId();
        NodeReference baseNodeReference = new NodeReference().setId(nodeId).setKeyReference(keyReferenceArray);
        String featureNameAlias = configObject.getBase().getOutputKeys().isPresent() ? (String)((List)configObject.getBase().getOutputKeys().get()).get(0) : "__SequentialJoinDefaultOutputKey__0";
        if (configObject.getBase().getTransformation().isPresent()) {
            MvelExpression baseFeatureTransformationExpression = new MvelExpression().setMvel((String)configObject.getBase().getTransformation().get());
            List inputFeatureNames = MvelInputsResolver.getInstance().getInputFeatures(baseFeatureTransformationExpression.getMvel());
            TransformationFunction transformationFunction = this.makeTransformationFunction(baseFeatureTransformationExpression, inputFeatureNames, "feathr:lookup_mvel:0");
            Transformation transformationNode = graphBuilder.addNewTransformation().setInputs(new NodeReferenceArray(Collections.singleton(baseNodeReference))).setFunction(transformationFunction).setFeatureVersion(new FeatureVersion()).setFeatureName(featureNameAlias);
            int transformationNodeId = transformationNode.getId();
            NodeReference baseTransformationNodeReference = new NodeReference().setId(transformationNodeId).setKeyReference(keyReferenceArray);
            new Lookup.LookupKey();
            lookupKey = Lookup.LookupKey.create((NodeReference)baseTransformationNodeReference);
        } else {
            new Lookup.LookupKey();
            lookupKey = Lookup.LookupKey.create((NodeReference)baseNodeReference);
        }
        List expansionKeysArray = configObject.getExpansion().getKey();
        Lookup.LookupKeyArray lookupKeyArray = expansionKeysArray.stream().map(entityParameters::indexOf).map(position -> {
            Lookup.LookupKey lookupKey2;
            if (position == -1) {
                lookupKey2 = lookupKey;
            } else if (((String)entityParameters.get((int)position)).equals(featureNameAlias)) {
                lookupKey2 = lookupKey;
            } else {
                new Lookup.LookupKey();
                lookupKey2 = Lookup.LookupKey.create((KeyReference)new KeyReference().setPosition(position));
            }
            return lookupKey2;
        }).collect(Collectors.toCollection(Lookup.LookupKeyArray::new));
        String expansionFeatureName = configObject.getExpansion().getFeature();
        External expansionExternalFeatureNode = graphBuilder.addNewExternal().setName(expansionFeatureName);
        String aggType = configObject.getAggregation();
        FeatureVersionBuilder featureVersionBuilder = new FeatureVersionBuilder(new TensorFeatureFormatBuilderFactory(), DefaultValueBuilder.getInstance(), FrameFeatureTypeBuilder.getInstance());
        FeatureVersion featureVersion = featureVersionBuilder.build((DerivationConfig)configObject);
        Lookup lookup = graphBuilder.addNewLookup().setLookupNode(expansionExternalFeatureNode.getId()).setLookupKey(lookupKeyArray).setAggregation(aggType).setFeatureName(configElementName).setFeatureVersion(featureVersion);
        graphBuilder.addFeatureName(configElementName, lookup.getId());
        return graphBuilder.build();
    }

    private TransformationFunction makeTransformationFunction(MvelExpression input, List<String> parameterNames, String operator) {
        TransformationFunction tf = this.makeTransformationFunction(input, operator);
        tf.getParameters().put("parameterNames", (Object)String.join((CharSequence)",", parameterNames));
        return tf;
    }

    private TransformationFunction makeTransformationFunction(MvelExpression input, String operator) {
        return new TransformationFunction().setOperator(operator).setParameters(new StringMap(Collections.singletonMap("expression", input.getMvel())));
    }
}

