/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.compute.converter;

import com.linkedin.data.template.StringMap;
import com.linkedin.feathr.compute.ComputeGraph;
import com.linkedin.feathr.compute.ComputeGraphBuilder;
import com.linkedin.feathr.compute.External;
import com.linkedin.feathr.compute.FeatureVersion;
import com.linkedin.feathr.compute.NodeReferenceArray;
import com.linkedin.feathr.compute.SqlUtil;
import com.linkedin.feathr.compute.Transformation;
import com.linkedin.feathr.compute.TransformationFunction;
import com.linkedin.feathr.compute.builder.DefaultValueBuilder;
import com.linkedin.feathr.compute.builder.FeatureVersionBuilder;
import com.linkedin.feathr.compute.builder.FrameFeatureTypeBuilder;
import com.linkedin.feathr.compute.builder.TensorFeatureFormatBuilderFactory;
import com.linkedin.feathr.compute.converter.ConverterUtils;
import com.linkedin.feathr.compute.converter.FeatureDefConfigConverter;
import com.linkedin.feathr.core.config.producer.ExprType;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfig;
import com.linkedin.feathr.core.config.producer.derivations.SimpleDerivationConfig;
import com.linkedin.feathr.core.config.producer.sources.SourceConfig;
import com.linkedin.feathr.core.utils.MvelInputsResolver;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

class SimpleDerivationConfigConverter
implements FeatureDefConfigConverter<SimpleDerivationConfig> {
    SimpleDerivationConfigConverter() {
    }

    @Override
    public ComputeGraph convert(String configElementName, SimpleDerivationConfig configObject, Map<String, SourceConfig> sourceMap) {
        List<String> inputFeatureNames = null;
        TransformationFunction transformationFunction = null;
        ComputeGraphBuilder graphBuilder = new ComputeGraphBuilder();
        if (configObject.getFeatureTypedExpr().getExprType().equals((Object)ExprType.MVEL)) {
            String mvel = configObject.getFeatureTypedExpr().getExpr();
            inputFeatureNames = MvelInputsResolver.getInstance().getInputFeatures(mvel);
            transformationFunction = new TransformationFunction().setOperator("feathr:derived_mvel:0").setParameters(new StringMap(Collections.singletonMap("expression", mvel)));
            transformationFunction.getParameters().put("parameterNames", (Object)String.join((CharSequence)",", inputFeatureNames));
        } else if (configObject.getFeatureTypedExpr().getExprType().equals((Object)ExprType.SQL)) {
            String sql = configObject.getFeatureTypedExpr().getExpr();
            inputFeatureNames = SqlUtil.getInputsFromSqlExpression(sql);
            transformationFunction = new TransformationFunction().setOperator("feathr:derived_spark_sql_feature_extractor:0").setParameters(new StringMap(Collections.singletonMap("expression", sql)));
            transformationFunction.getParameters().put("parameterNames", (Object)String.join((CharSequence)",", inputFeatureNames));
        }
        Map externalFeatureNodes = inputFeatureNames.stream().collect(Collectors.toMap(Function.identity(), name -> graphBuilder.addNewExternal().setName(name)));
        NodeReferenceArray nodeReferences = inputFeatureNames.stream().map(inputFeatureName -> {
            int featureDependencyNodeId = ((External)externalFeatureNodes.get(inputFeatureName)).getId();
            return ConverterUtils.makeNodeReferenceWithSimpleKeyReference(featureDependencyNodeId, 1);
        }).collect(Collectors.toCollection(NodeReferenceArray::new));
        FeatureVersionBuilder featureVersionBuilder = new FeatureVersionBuilder(new TensorFeatureFormatBuilderFactory(), DefaultValueBuilder.getInstance(), FrameFeatureTypeBuilder.getInstance());
        FeatureVersion featureVersion = featureVersionBuilder.build((DerivationConfig)configObject);
        Transformation transformation = graphBuilder.addNewTransformation().setInputs(nodeReferences).setFunction(transformationFunction).setFeatureName(configElementName).setFeatureVersion(featureVersion);
        graphBuilder.addFeatureName(configElementName, transformation.getId());
        return graphBuilder.build();
    }
}

