/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.consumer;

import com.linkedin.feathr.core.config.ConfigObj;
import com.linkedin.feathr.core.config.consumer.FeatureBagConfig;
import com.linkedin.feathr.core.config.consumer.SettingsConfig;
import com.linkedin.feathr.core.utils.Utils;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class JoinConfig
implements ConfigObj {
    public static final String SETTINGS = "settings";
    private final Optional<SettingsConfig> _settings;
    private final Map<String, FeatureBagConfig> _featureBagConfigs;
    private String _configStr;

    public JoinConfig(SettingsConfig settings, Map<String, FeatureBagConfig> featureBagConfigs) {
        this._settings = Optional.ofNullable(settings);
        this._featureBagConfigs = featureBagConfigs;
        this.constructConfigStr();
    }

    private void constructConfigStr() {
        StringBuilder sb = new StringBuilder();
        this._settings.ifPresent(s -> sb.append(SETTINGS).append(": ").append(s).append("\n"));
        sb.append(Utils.string(this._featureBagConfigs, "\n")).append("\n");
        this._configStr = sb.toString();
    }

    public Optional<SettingsConfig> getSettings() {
        return this._settings;
    }

    public Map<String, FeatureBagConfig> getFeatureBagConfigs() {
        return this._featureBagConfigs;
    }

    public Optional<FeatureBagConfig> getFeatureBagConfig(String featureBagName) {
        return Optional.ofNullable(this._featureBagConfigs.get(featureBagName));
    }

    public String toString() {
        return this._configStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinConfig that = (JoinConfig)o;
        return Objects.equals(this._settings, that._settings) && Objects.equals(this._featureBagConfigs, that._featureBagConfigs);
    }

    public int hashCode() {
        return Objects.hash(this._settings, this._featureBagConfigs);
    }
}

