/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.consumer;

import com.linkedin.feathr.core.config.ConfigObj;
import com.linkedin.feathr.core.config.consumer.AbsoluteTimeRangeConfig;
import com.linkedin.feathr.core.config.consumer.RelativeTimeRangeConfig;
import java.util.Objects;
import java.util.Optional;

public class ObservationDataTimeSettingsConfig
implements ConfigObj {
    public static final String ABSOLUTE_TIME_RANGE = "absoluteTimeRange";
    public static final String RELATIVE_TIME_RANGE = "relativeTimeRange";
    private final Optional<AbsoluteTimeRangeConfig> _absoluteTimeRangeConfig;
    private final Optional<RelativeTimeRangeConfig> _relativeTimeRangeConfig;
    private String _configStr;

    public ObservationDataTimeSettingsConfig(AbsoluteTimeRangeConfig absoluteTimeRangeConfig, RelativeTimeRangeConfig relativeTimeRangeConfig) {
        this._absoluteTimeRangeConfig = Optional.ofNullable(absoluteTimeRangeConfig);
        this._relativeTimeRangeConfig = Optional.ofNullable(relativeTimeRangeConfig);
        this.constructConfigStr();
    }

    private void constructConfigStr() {
        StringBuilder sb = new StringBuilder();
        this._absoluteTimeRangeConfig.ifPresent(t -> sb.append(t).append(": ").append(t).append("\n"));
        this._relativeTimeRangeConfig.ifPresent(t -> sb.append(t).append(": ").append(t).append("\n"));
        this._configStr = sb.toString();
    }

    public String toString() {
        return this._configStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObservationDataTimeSettingsConfig)) {
            return false;
        }
        ObservationDataTimeSettingsConfig that = (ObservationDataTimeSettingsConfig)o;
        return Objects.equals(this._absoluteTimeRangeConfig, that._absoluteTimeRangeConfig) && Objects.equals(this._relativeTimeRangeConfig, that._relativeTimeRangeConfig);
    }

    public int hashCode() {
        return Objects.hash(this._absoluteTimeRangeConfig, this._relativeTimeRangeConfig);
    }

    public Optional<AbsoluteTimeRangeConfig> getAbsoluteTimeRange() {
        return this._absoluteTimeRangeConfig;
    }

    public Optional<RelativeTimeRangeConfig> getRelativeTimeRange() {
        return this._relativeTimeRangeConfig;
    }
}

