/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.consumer;

import com.linkedin.feathr.core.config.ConfigObj;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public class RelativeTimeRangeConfig
implements ConfigObj {
    public static final String WINDOW = "window";
    public static final String OFFSET = "offset";
    private final Duration _window;
    private final Optional<Duration> _offset;
    private String _configStr;

    public RelativeTimeRangeConfig(Duration window, Duration offset) {
        this._window = window;
        this._offset = Optional.ofNullable(offset);
        this.constructConfigStr();
    }

    private void constructConfigStr() {
        StringBuilder sb = new StringBuilder();
        sb.append(WINDOW).append(": ").append(this._window).append("\n");
        this._offset.ifPresent(t -> sb.append(OFFSET).append(": ").append(t).append("\n"));
        this._configStr = sb.toString();
    }

    public String toString() {
        return this._configStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelativeTimeRangeConfig)) {
            return false;
        }
        RelativeTimeRangeConfig that = (RelativeTimeRangeConfig)o;
        return Objects.equals(this._window, that._window) && Objects.equals(this._offset, that._offset);
    }

    public int hashCode() {
        return Objects.hash(this._window, this._offset);
    }

    public Duration getWindow() {
        return this._window;
    }

    public Optional<Duration> getOffset() {
        return this._offset;
    }
}

