/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.consumer;

import com.linkedin.feathr.core.config.ConfigObj;
import com.linkedin.feathr.core.config.consumer.JoinTimeSettingsConfig;
import com.linkedin.feathr.core.config.consumer.ObservationDataTimeSettingsConfig;
import java.util.Objects;
import java.util.Optional;

public final class SettingsConfig
implements ConfigObj {
    public static final String OBSERVATION_DATA_TIME_SETTINGS = "observationDataTimeSettings";
    public static final String JOIN_TIME_SETTINGS = "joinTimeSettings";
    private final Optional<ObservationDataTimeSettingsConfig> _observationDataTimeSettings;
    private final Optional<JoinTimeSettingsConfig> _joinTimeSettings;
    private String _configStr;

    public SettingsConfig(ObservationDataTimeSettingsConfig observationDataTimeSettings, JoinTimeSettingsConfig joinTimeSettings) {
        this._observationDataTimeSettings = Optional.ofNullable(observationDataTimeSettings);
        this._joinTimeSettings = Optional.ofNullable(joinTimeSettings);
        this.constructConfigStr();
    }

    private void constructConfigStr() {
        StringBuilder sb = new StringBuilder();
        this._observationDataTimeSettings.ifPresent(t -> sb.append(OBSERVATION_DATA_TIME_SETTINGS).append(": ").append(t).append("\n"));
        this._joinTimeSettings.ifPresent(t -> sb.append(JOIN_TIME_SETTINGS).append(": ").append(t).append("\n"));
        this._configStr = sb.toString();
    }

    public String toString() {
        return this._configStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SettingsConfig)) {
            return false;
        }
        SettingsConfig that = (SettingsConfig)o;
        return Objects.equals(this._observationDataTimeSettings, that._observationDataTimeSettings) && Objects.equals(this._joinTimeSettings, that._joinTimeSettings);
    }

    public int hashCode() {
        return Objects.hash(this._observationDataTimeSettings, this._joinTimeSettings);
    }

    public Optional<ObservationDataTimeSettingsConfig> getTimeWindowJoin() {
        return this._observationDataTimeSettings;
    }

    public Optional<JoinTimeSettingsConfig> getObservationTimeInfo() {
        return this._joinTimeSettings;
    }
}

