/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer;

import com.linkedin.feathr.core.config.ConfigObj;
import com.linkedin.feathr.core.config.producer.anchors.AnchorsConfig;
import com.linkedin.feathr.core.config.producer.derivations.DerivationsConfig;
import com.linkedin.feathr.core.config.producer.sources.SourcesConfig;
import java.util.Objects;
import java.util.Optional;

public final class FeatureDefConfig
implements ConfigObj {
    public static final String SOURCES = "sources";
    public static final String ANCHORS = "anchors";
    public static final String DERIVATIONS = "derivations";
    public static final String FEATURES = "features";
    private final Optional<SourcesConfig> _sourcesConfig;
    private final Optional<AnchorsConfig> _anchorsConfig;
    private final Optional<DerivationsConfig> _derivationsConfig;
    private String _configStr;

    public FeatureDefConfig(SourcesConfig sourcesConfig, AnchorsConfig anchorsConfig, DerivationsConfig derivationsConfig) {
        this._sourcesConfig = Optional.ofNullable(sourcesConfig);
        this._anchorsConfig = Optional.ofNullable(anchorsConfig);
        this._derivationsConfig = Optional.ofNullable(derivationsConfig);
        this.constructConfigStr();
    }

    private void constructConfigStr() {
        StringBuilder strBldr = new StringBuilder();
        this._sourcesConfig.ifPresent(cfg -> strBldr.append(SOURCES).append(": ").append(cfg).append("\n"));
        this._anchorsConfig.ifPresent(cfg -> strBldr.append(ANCHORS).append(": ").append(cfg).append("\n"));
        this._derivationsConfig.ifPresent(cfg -> strBldr.append(DERIVATIONS).append(": ").append(cfg).append("\n"));
        this._configStr = strBldr.toString();
    }

    public Optional<SourcesConfig> getSourcesConfig() {
        return this._sourcesConfig;
    }

    public Optional<AnchorsConfig> getAnchorsConfig() {
        return this._anchorsConfig;
    }

    public Optional<DerivationsConfig> getDerivationsConfig() {
        return this._derivationsConfig;
    }

    public String toString() {
        return this._configStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureDefConfig that = (FeatureDefConfig)o;
        return Objects.equals(this._sourcesConfig, that._sourcesConfig) && Objects.equals(this._anchorsConfig, that._anchorsConfig) && Objects.equals(this._derivationsConfig, that._derivationsConfig);
    }

    public int hashCode() {
        return Objects.hash(this._sourcesConfig, this._anchorsConfig, this._derivationsConfig);
    }
}

