/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.anchors;

import com.linkedin.feathr.core.config.producer.anchors.AnchorConfig;
import com.linkedin.feathr.core.config.producer.anchors.FeatureConfig;
import com.linkedin.feathr.core.config.producer.anchors.LateralViewParams;
import com.linkedin.feathr.core.config.producer.anchors.TypedKey;
import com.linkedin.feathr.core.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class AnchorConfigWithKey
extends AnchorConfig {
    private final TypedKey _typedKey;
    private final Optional<List<String>> _keyAlias;
    private final Optional<LateralViewParams> _lateralViewParams;
    private String _configStr;

    public AnchorConfigWithKey(String source, TypedKey typedKey, List<String> keyAlias, LateralViewParams lateralViewParams, Map<String, FeatureConfig> features) {
        super(source, features);
        this._typedKey = typedKey;
        this._keyAlias = Optional.ofNullable(keyAlias);
        this._lateralViewParams = Optional.ofNullable(lateralViewParams);
    }

    public AnchorConfigWithKey(String source, TypedKey typedKey, LateralViewParams lateralViewParams, Map<String, FeatureConfig> features) {
        this(source, typedKey, null, lateralViewParams, features);
    }

    public List<String> getKey() {
        return this._typedKey.getKey();
    }

    public TypedKey getTypedKey() {
        return this._typedKey;
    }

    public Optional<List<String>> getKeyAlias() {
        return this._keyAlias;
    }

    public Optional<LateralViewParams> getLateralViewParams() {
        return this._lateralViewParams;
    }

    public String toString() {
        if (this._configStr == null) {
            this._configStr = String.join((CharSequence)"\n", String.join((CharSequence)": ", "source", this.getSource()), this._typedKey.toString(), "features:{\n" + Utils.string(this.getFeatures()) + "\n}");
            this._keyAlias.ifPresent(ka -> {
                this._configStr = String.join((CharSequence)"\n", this._configStr, String.join((CharSequence)": ", "keyAlias", Utils.string(ka)));
            });
            this._lateralViewParams.ifPresent(lvp -> {
                this._configStr = String.join((CharSequence)"\n", this._configStr, "lateralViewParameters: {\n" + lvp + "\n}");
            });
        }
        return this._configStr;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AnchorConfigWithKey that = (AnchorConfigWithKey)o;
        return Objects.equals(this._typedKey, that._typedKey) && Objects.equals(this._keyAlias, that._keyAlias) && Objects.equals(this._lateralViewParams, that._lateralViewParams);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this._typedKey, this._keyAlias, this._lateralViewParams);
    }
}

