/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.anchors;

import com.linkedin.feathr.core.config.producer.anchors.AnchorConfig;
import com.linkedin.feathr.core.config.producer.anchors.FeatureConfig;
import com.linkedin.feathr.core.config.producer.anchors.LateralViewParams;
import com.linkedin.feathr.core.utils.Utils;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class AnchorConfigWithKeyExtractor
extends AnchorConfig {
    private final String _keyExtractor;
    private final Optional<LateralViewParams> _lateralViewParams;
    private String _configStr;

    public AnchorConfigWithKeyExtractor(String source, String keyExtractor, Map<String, FeatureConfig> features, LateralViewParams lateralViewParams) {
        super(source, features);
        this._keyExtractor = keyExtractor;
        this._lateralViewParams = Optional.ofNullable(lateralViewParams);
    }

    public AnchorConfigWithKeyExtractor(String source, String keyExtractor, Map<String, FeatureConfig> features) {
        this(source, keyExtractor, features, null);
    }

    public String getKeyExtractor() {
        return this._keyExtractor;
    }

    public Optional<LateralViewParams> getLateralViewParams() {
        return this._lateralViewParams;
    }

    public String toString() {
        if (this._configStr == null) {
            this._configStr = String.join((CharSequence)"\n", String.join((CharSequence)": ", "source", this.getSource()), String.join((CharSequence)": ", "keyExtractor", this.getKeyExtractor()), "features:{\n" + Utils.string(this.getFeatures()) + "\n}");
            this._lateralViewParams.ifPresent(lvp -> {
                this._configStr = String.join((CharSequence)"\n", this._configStr, "lateralViewParameters: {\n" + lvp + "\n}");
            });
        }
        return this._configStr;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AnchorConfigWithKeyExtractor that = (AnchorConfigWithKeyExtractor)o;
        return Objects.equals(this._keyExtractor, that._keyExtractor) && Objects.equals(this._lateralViewParams, that._lateralViewParams);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this._keyExtractor, this._lateralViewParams);
    }
}

