/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.anchors;

import com.linkedin.feathr.core.config.producer.ExprType;
import com.linkedin.feathr.core.config.producer.anchors.FeatureConfig;
import com.linkedin.feathr.core.config.producer.common.FeatureTypeConfig;
import com.linkedin.feathr.core.config.producer.definitions.FeatureType;
import java.util.Objects;
import java.util.Optional;

public final class ComplexFeatureConfig
extends FeatureConfig {
    private final String _featureExpr;
    private final ExprType _exprType;
    private final Optional<String> _defaultValue;
    private final Optional<FeatureTypeConfig> _featureTypeConfig;
    private String _configStr;

    public ComplexFeatureConfig(String featureExpr, ExprType exprType, String defaultValue, FeatureTypeConfig featureTypeConfig) {
        this._featureExpr = featureExpr;
        this._exprType = exprType;
        this._defaultValue = Optional.ofNullable(defaultValue);
        this._featureTypeConfig = Optional.ofNullable(featureTypeConfig);
        this.constructConfigStr();
    }

    @Deprecated
    public ComplexFeatureConfig(String featureExpr, String featureType, String defaultValue) {
        this(featureExpr, defaultValue, new FeatureTypeConfig(FeatureType.valueOf(featureType)));
    }

    @Deprecated
    public ComplexFeatureConfig(String featureExpr, FeatureTypeConfig featureTypeConfig) {
        this(featureExpr, null, featureTypeConfig);
    }

    @Deprecated
    public ComplexFeatureConfig(String featureExpr, String defaultValue, FeatureTypeConfig featureTypeConfig) {
        this(featureExpr, ExprType.MVEL, defaultValue, featureTypeConfig);
    }

    @Deprecated
    public ComplexFeatureConfig(String featureExpr, ExprType exprType, FeatureType featureType, String defaultValue) {
        this(featureExpr, exprType, defaultValue, featureType == null ? null : new FeatureTypeConfig(featureType));
    }

    public String getFeatureExpr() {
        return this._featureExpr;
    }

    public ExprType getExprType() {
        return this._exprType;
    }

    @Deprecated
    public Optional<String> getFeatureType() {
        return this.getFeatureTypeConfig().map(featureTypeConfig -> featureTypeConfig.getFeatureType().name());
    }

    @Override
    public Optional<String> getDefaultValue() {
        return this._defaultValue;
    }

    @Override
    public Optional<FeatureTypeConfig> getFeatureTypeConfig() {
        return this._featureTypeConfig;
    }

    private void constructConfigStr() {
        StringBuilder sb = new StringBuilder();
        sb.append("def").append(": ").append(this._featureExpr).append("\n");
        this._defaultValue.ifPresent(v -> sb.append("default").append(": ").append((String)v).append("\n"));
        this._configStr = sb.toString();
    }

    public String toString() {
        return this._configStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComplexFeatureConfig that = (ComplexFeatureConfig)o;
        return Objects.equals(this._featureExpr, that._featureExpr) && this._exprType == that._exprType && Objects.equals(this._defaultValue, that._defaultValue) && Objects.equals(this._featureTypeConfig, that._featureTypeConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._featureExpr, this._exprType, this._defaultValue, this._featureTypeConfig});
    }
}

