/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.anchors;

import java.util.Objects;
import java.util.Optional;

public final class LateralViewParams {
    public static final String LATERAL_VIEW_DEF = "lateralViewDef";
    public static final String LATERAL_VIEW_ITEM_ALIAS = "lateralViewItemAlias";
    public static final String LATERAL_VIEW_FILTER = "lateralViewFilter";
    private final String _def;
    private final String _itemAlias;
    private final Optional<String> _filter;
    private String _configStr;

    public LateralViewParams(String def, String itemAlias, String filter) {
        this._def = def;
        this._itemAlias = itemAlias;
        this._filter = Optional.ofNullable(filter);
    }

    public LateralViewParams(String def, String itemAlias) {
        this(def, itemAlias, null);
    }

    public String getDef() {
        return this._def;
    }

    public String getItemAlias() {
        return this._itemAlias;
    }

    public Optional<String> getFilter() {
        return this._filter;
    }

    public String toString() {
        if (this._configStr == null) {
            this._configStr = String.join((CharSequence)"\n", "lateralViewDef: " + this._def, "lateralViewItemAlias: " + this._itemAlias);
            this._filter.ifPresent(filter -> {
                this._configStr = String.join((CharSequence)"\n", this._configStr, "lateralViewFilter: " + filter);
            });
        }
        return this._configStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LateralViewParams that = (LateralViewParams)o;
        return Objects.equals(this._def, that._def) && Objects.equals(this._itemAlias, that._itemAlias) && Objects.equals(this._filter, that._filter);
    }

    public int hashCode() {
        return Objects.hash(this._def, this._itemAlias, this._filter);
    }
}

