/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.common;

import com.linkedin.feathr.core.utils.ConfigUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.List;

public class KeyListExtractor {
    private static final KeyListExtractor INSTANCE = new KeyListExtractor();
    private static final String KEY_PATH = "MOCK_KEY_EXPR_PATH";
    private static final String HOCON_PREFIX = "{ ";
    private static final String HOCON_SUFFIX = " }";
    private static final String HOCON_DELIM = " : ";

    public static KeyListExtractor getInstance() {
        return INSTANCE;
    }

    private KeyListExtractor() {
    }

    public List<String> extractFromHocon(String keyExpression) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(HOCON_PREFIX).append(KEY_PATH).append(HOCON_DELIM).append(keyExpression).append(HOCON_SUFFIX);
        String hoconFullString = stringBuilder.toString();
        Config config = ConfigFactory.parseString((String)hoconFullString);
        return ConfigUtils.getStringList(config, KEY_PATH);
    }
}

