/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.derivations;

import com.linkedin.feathr.core.config.producer.derivations.KeyedFeature;
import com.linkedin.feathr.core.utils.Utils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class BaseFeatureConfig
extends KeyedFeature {
    private final Optional<List<String>> _outputKeys;
    private final Optional<String> _transformation;
    private final Optional<String> _transformationClass;
    private String _configStr;

    public BaseFeatureConfig(String rawkeyExpr, String feature, List<String> outputKeys, String transformation, String transformationClass) {
        super(rawkeyExpr, feature);
        this._outputKeys = Optional.ofNullable(outputKeys);
        this._transformation = Optional.ofNullable(transformation);
        this._transformationClass = Optional.ofNullable(transformationClass);
    }

    @Override
    public String toString() {
        if (this._configStr == null) {
            this._configStr = super.toString();
            this._outputKeys.ifPresent(k -> {
                this._configStr = String.join((CharSequence)"\n", this._configStr, String.join((CharSequence)": ", "outputKey", Utils.string(k)));
            });
            this._transformation.ifPresent(t -> {
                this._configStr = String.join((CharSequence)"\n", this._configStr, String.join((CharSequence)": ", "transformation", t));
            });
            this._transformationClass.ifPresent(t -> {
                this._configStr = String.join((CharSequence)"\n", this._configStr, String.join((CharSequence)": ", "transformationClass", t));
            });
        }
        return this._configStr;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseFeatureConfig that = (BaseFeatureConfig)o;
        return Objects.equals(this._outputKeys, that._outputKeys) && Objects.equals(this._transformation, that._transformation) && Objects.equals(this._transformationClass, that._transformationClass);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this._outputKeys, this._transformation, this._transformationClass);
    }

    public Optional<List<String>> getOutputKeys() {
        return this._outputKeys;
    }

    public Optional<String> getTransformation() {
        return this._transformation;
    }

    public Optional<String> getTransformationClass() {
        return this._transformationClass;
    }
}

