/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.derivations;

import com.linkedin.feathr.core.config.producer.common.FeatureTypeConfig;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfig;
import com.linkedin.feathr.core.config.producer.derivations.KeyedFeature;
import com.linkedin.feathr.core.utils.Utils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class DerivationConfigWithExtractor
implements DerivationConfig {
    private final List<String> _keys;
    private final List<KeyedFeature> _inputs;
    private final String _className;
    private final Optional<FeatureTypeConfig> _featureTypeConfig;
    private String _configStr;

    public DerivationConfigWithExtractor(List<String> keys, List<KeyedFeature> inputs, String className) {
        this._keys = keys;
        this._inputs = inputs;
        this._className = className;
        this._featureTypeConfig = Optional.empty();
        StringBuilder sb = new StringBuilder();
        sb.append("key").append(": ").append(Utils.string(keys)).append("\n").append("inputs").append(": ").append(Utils.string(inputs)).append("\n").append("class").append(": ").append(className).append("\n");
        this._configStr = sb.toString();
    }

    public DerivationConfigWithExtractor(List<String> keys, List<KeyedFeature> inputs, String className, FeatureTypeConfig featureTypeConfig) {
        this._keys = keys;
        this._inputs = inputs;
        this._className = className;
        this._featureTypeConfig = Optional.ofNullable(featureTypeConfig);
        StringBuilder sb = new StringBuilder();
        sb.append("key").append(": ").append(Utils.string(keys)).append("\n").append("inputs").append(": ").append(Utils.string(inputs)).append("\n").append("class").append(": ").append(className).append("\n");
        this._configStr = sb.toString();
    }

    public List<String> getKeys() {
        return this._keys;
    }

    public List<KeyedFeature> getInputs() {
        return this._inputs;
    }

    public String getClassName() {
        return this._className;
    }

    @Override
    public Optional<FeatureTypeConfig> getFeatureTypeConfig() {
        return this._featureTypeConfig;
    }

    public String toString() {
        return this._configStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DerivationConfigWithExtractor that = (DerivationConfigWithExtractor)o;
        return Objects.equals(this._keys, that._keys) && Objects.equals(this._inputs, that._inputs) && Objects.equals(this._className, that._className) && Objects.equals(this._featureTypeConfig, that._featureTypeConfig);
    }

    public int hashCode() {
        return Objects.hash(this._keys, this._inputs, this._className, this._featureTypeConfig);
    }
}

