/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.derivations;

import com.linkedin.feathr.core.config.producer.common.FeatureTypeConfig;
import com.linkedin.feathr.core.config.producer.derivations.BaseFeatureConfig;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfig;
import com.linkedin.feathr.core.config.producer.derivations.KeyedFeature;
import com.linkedin.feathr.core.utils.Utils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class SequentialJoinConfig
implements DerivationConfig {
    private final List<String> _keys;
    private final BaseFeatureConfig _base;
    private final KeyedFeature _expansion;
    private final String _aggregation;
    private final Optional<FeatureTypeConfig> _featureTypeConfig;
    private String _configStr;

    public SequentialJoinConfig(List<String> keys, BaseFeatureConfig base, KeyedFeature expansion, String aggregation, FeatureTypeConfig featureTypeConfig) {
        this._keys = keys;
        this._base = base;
        this._expansion = expansion;
        this._aggregation = aggregation;
        this._featureTypeConfig = Optional.ofNullable(featureTypeConfig);
    }

    public SequentialJoinConfig(List<String> keys, BaseFeatureConfig base, KeyedFeature expansion, String aggregation) {
        this._keys = keys;
        this._base = base;
        this._expansion = expansion;
        this._aggregation = aggregation;
        this._featureTypeConfig = Optional.empty();
    }

    public String toString() {
        if (this._configStr == null) {
            this._configStr = String.join((CharSequence)"\n", String.join((CharSequence)": ", "key", Utils.string(this._keys)), String.join((CharSequence)":\n", "base", this._base.toString()), String.join((CharSequence)":\n", "expansion", this._expansion.toString()), String.join((CharSequence)": ", "aggregation", this._aggregation));
        }
        return this._configStr;
    }

    public List<String> getKeys() {
        return this._keys;
    }

    public BaseFeatureConfig getBase() {
        return this._base;
    }

    public KeyedFeature getExpansion() {
        return this._expansion;
    }

    public String getAggregation() {
        return this._aggregation;
    }

    @Override
    public Optional<FeatureTypeConfig> getFeatureTypeConfig() {
        return this._featureTypeConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequentialJoinConfig that = (SequentialJoinConfig)o;
        return Objects.equals(this._keys, that._keys) && Objects.equals(this._base, that._base) && Objects.equals(this._expansion, that._expansion) && Objects.equals(this._aggregation, that._aggregation) && Objects.equals(this._featureTypeConfig, that._featureTypeConfig);
    }

    public int hashCode() {
        return Objects.hash(this._keys, this._base, this._expansion, this._aggregation, this._featureTypeConfig);
    }
}

