/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.sources;

import com.linkedin.feathr.core.config.producer.sources.SourceConfig;
import com.linkedin.feathr.core.config.producer.sources.SourceType;
import java.util.Objects;

public final class CouchbaseConfig
extends SourceConfig {
    private final String _bucketName;
    private final String _keyExpr;
    private final String _documentModel;
    public static final String BUCKET_NAME = "bucketName";
    public static final String KEY_EXPR = "keyExpr";
    public static final String BOOTSTRAP_URIS = "bootstrapUris";
    public static final String DOCUMENT_MODEL = "documentModel";

    public CouchbaseConfig(String sourceName, String bucketName, String keyExpr, String documentModel) {
        super(sourceName);
        this._bucketName = bucketName;
        this._keyExpr = keyExpr;
        this._documentModel = documentModel;
    }

    @Override
    public SourceType getSourceType() {
        return SourceType.COUCHBASE;
    }

    public String getBucketName() {
        return this._bucketName;
    }

    public String getKeyExpr() {
        return this._keyExpr;
    }

    public String getDocumentModel() {
        return this._documentModel;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CouchbaseConfig that = (CouchbaseConfig)o;
        return Objects.equals(this._bucketName, that._bucketName) && Objects.equals(this._keyExpr, that._keyExpr) && Objects.equals(this._documentModel, that._documentModel);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this._bucketName, this._keyExpr, this._documentModel);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CouchbaseConfig{");
        sb.append("_bucketName='").append(this._bucketName).append('\'');
        sb.append(", _keyExpr='").append(this._keyExpr).append('\'');
        sb.append(", _documentModel='").append(this._documentModel).append('\'');
        sb.append(", _sourceName='").append(this._sourceName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

