/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.sources;

import com.linkedin.feathr.core.config.producer.sources.SourceConfig;
import com.linkedin.feathr.core.config.producer.sources.SourceType;
import java.util.Objects;

public final class EspressoConfig
extends SourceConfig {
    private final String _database;
    private final String _table;
    private final String _d2Uri;
    private final String _keyExpr;
    private final String _name;
    public static final String DATABASE = "database";
    public static final String TABLE = "table";
    public static final String D2_URI = "d2Uri";
    public static final String KEY_EXPR = "keyExpr";

    public EspressoConfig(String sourceName, String database, String table, String d2Uri, String keyExpr) {
        super(sourceName);
        this._database = database;
        this._table = table;
        this._d2Uri = d2Uri;
        this._keyExpr = keyExpr;
        this._name = database + "/" + table;
    }

    public String getDatabase() {
        return this._database;
    }

    public String getTable() {
        return this._table;
    }

    public String getD2Uri() {
        return this._d2Uri;
    }

    public String getKeyExpr() {
        return this._keyExpr;
    }

    @Override
    public SourceType getSourceType() {
        return SourceType.ESPRESSO;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EspressoConfig that = (EspressoConfig)o;
        return Objects.equals(this._database, that._database) && Objects.equals(this._table, that._table) && Objects.equals(this._d2Uri, that._d2Uri) && Objects.equals(this._keyExpr, that._keyExpr) && Objects.equals(this._name, that._name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this._database, this._table, this._d2Uri, this._keyExpr, this._name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EspressoConfig{");
        sb.append("_database='").append(this._database).append('\'');
        sb.append(", _table='").append(this._table).append('\'');
        sb.append(", _d2Uri='").append(this._d2Uri).append('\'');
        sb.append(", _keyExpr=").append(this._keyExpr);
        sb.append(", _name='").append(this._name).append('\'');
        sb.append(", _sourceName='").append(this._sourceName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

