/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.sources;

import com.linkedin.feathr.core.config.producer.sources.SlidingWindowAggrConfig;
import com.linkedin.feathr.core.config.producer.sources.SourceConfig;
import com.linkedin.feathr.core.config.producer.sources.SourceType;
import java.util.Objects;
import java.util.Optional;

public final class KafkaConfig
extends SourceConfig {
    private final String _stream;
    private final Optional<SlidingWindowAggrConfig> _swaConfig;
    public static final String STREAM = "stream";

    public KafkaConfig(String sourceName, String stream, SlidingWindowAggrConfig swaConfig) {
        super(sourceName);
        this._stream = stream;
        this._swaConfig = Optional.ofNullable(swaConfig);
    }

    public String getStream() {
        return this._stream;
    }

    public Optional<SlidingWindowAggrConfig> getSwaConfig() {
        return this._swaConfig;
    }

    @Override
    public SourceType getSourceType() {
        return SourceType.KAFKA;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaConfig that = (KafkaConfig)o;
        return Objects.equals(this._stream, that._stream) && Objects.equals(this._swaConfig, that._swaConfig);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this._stream, this._swaConfig);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("KafkaConfig{");
        sb.append("_stream='").append(this._stream).append('\'');
        sb.append(", _swaConfig=").append(this._swaConfig);
        sb.append(", _sourceName='").append(this._sourceName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

