/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.sources;

import com.linkedin.feathr.core.config.producer.sources.SourceConfig;
import com.linkedin.feathr.core.config.producer.sources.SourceType;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;

public class PinotConfig
extends SourceConfig {
    private final String _resourceName;
    private final String _queryTemplate;
    private final String[] _queryArguments;
    private final String[] _queryKeyColumns;
    public static final String RESOURCE_NAME = "resourceName";
    public static final String QUERY_TEMPLATE = "queryTemplate";
    public static final String QUERY_ARGUMENTS = "queryArguments";
    public static final String QUERY_KEY_COLUMNS = "queryKeyColumns";

    public PinotConfig(@Nonnull String sourceName, @Nonnull String resourceName, @Nonnull String queryTemplate, @Nonnull String[] queryArguments, @Nonnull String[] queryKeyColumns) {
        super(sourceName);
        this._resourceName = resourceName;
        this._queryTemplate = queryTemplate;
        this._queryArguments = queryArguments;
        this._queryKeyColumns = queryKeyColumns;
    }

    public String getResourceName() {
        return this._resourceName;
    }

    public String getQueryTemplate() {
        return this._queryTemplate;
    }

    public String[] getQueryArguments() {
        return this._queryArguments;
    }

    public String[] getQueryKeyColumns() {
        return this._queryKeyColumns;
    }

    @Override
    public SourceType getSourceType() {
        return SourceType.PINOT;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PinotConfig that = (PinotConfig)o;
        return Objects.equals(this._resourceName, that._resourceName) && Objects.equals(this._queryTemplate, that._queryTemplate) && Arrays.equals(this._queryArguments, that._queryArguments) && Arrays.equals(this._queryKeyColumns, that._queryKeyColumns);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this._resourceName, this._queryTemplate);
        result = 31 * result + Arrays.hashCode(this._queryArguments) + Arrays.hashCode(this._queryKeyColumns);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PinotConfig{");
        sb.append("_resourceName='").append(this._resourceName).append('\'');
        sb.append(", _queryTemplate='").append(this._queryTemplate).append('\'');
        sb.append(", _queryArguments='").append(Arrays.toString(this._queryArguments)).append('\'');
        sb.append(", _queryKeyColumns='").append(Arrays.toString(this._queryKeyColumns)).append('\'');
        sb.append(", _sourceName='").append(this._sourceName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

