/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.sources;

import com.linkedin.feathr.core.config.producer.sources.SourceConfig;
import com.linkedin.feathr.core.config.producer.sources.SourceType;
import java.util.Objects;
import javax.annotation.Nonnull;

public class VectorConfig
extends SourceConfig {
    private final String _keyExpr;
    private final String _featureSourceName;
    public static final String KEY_EXPR = "keyExpr";
    public static final String FEATURE_SOURCE_NAME = "featureSourceName";

    public VectorConfig(@Nonnull String sourceName, @Nonnull String keyExpr, @Nonnull String featureSourceName) {
        super(sourceName);
        this._keyExpr = keyExpr;
        this._featureSourceName = featureSourceName;
    }

    public String getKeyExpr() {
        return this._keyExpr;
    }

    public String getFeatureSourceName() {
        return this._featureSourceName;
    }

    @Override
    public SourceType getSourceType() {
        return SourceType.VECTOR;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VectorConfig that = (VectorConfig)o;
        return Objects.equals(this._keyExpr, that._keyExpr) && Objects.equals(this._featureSourceName, that._featureSourceName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this._keyExpr, this._featureSourceName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VectorConfig{");
        sb.append("_keyExpr=").append(this._keyExpr);
        sb.append(", _featureSourceName=").append(this._featureSourceName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

