/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe;

import com.linkedin.feathr.core.config.ConfigType;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.linkedin.feathr.core.configbuilder.typesafe.TypesafeConfigBuilder;
import com.linkedin.feathr.core.configdataprovider.UrlConfigDataProvider;
import com.typesafe.config.Config;
import java.net.URL;
import java.util.Objects;

public class FrameConfigFileChecker {
    private FrameConfigFileChecker() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isConfigFile(URL url) {
        try (UrlConfigDataProvider cdp = new UrlConfigDataProvider(url);){
            Objects.requireNonNull(cdp, "ConfigDataProvider object can't be null");
            TypesafeConfigBuilder builder = new TypesafeConfigBuilder();
            Config config = builder.buildTypesafeConfig(ConfigType.FeatureDef, cdp);
            boolean bl = config.hasPath("anchors") || config.hasPath("derivations") || config.hasPath("sources");
            return bl;
        }
        catch (Exception e) {
            throw new ConfigBuilderException("Error in building config object", e);
        }
    }
}

