/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.consumer;

import com.linkedin.feathr.core.config.consumer.AbsoluteTimeRangeConfig;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.linkedin.feathr.core.utils.ConfigUtils;
import com.typesafe.config.Config;
import org.apache.log4j.Logger;

public class AbsoluteTimeRangeConfigBuilder {
    private static final Logger logger = Logger.getLogger(AbsoluteTimeRangeConfigBuilder.class);

    private AbsoluteTimeRangeConfigBuilder() {
    }

    public static AbsoluteTimeRangeConfig build(Config absoluteTimeRangeConfig) {
        String timeFormat;
        String endTime;
        String startTime;
        String string = startTime = absoluteTimeRangeConfig.hasPath("startTime") ? absoluteTimeRangeConfig.getString("startTime") : null;
        if (startTime == null) {
            throw new ConfigBuilderException(String.format("startTime is a required parameter in absoluteTimeRage config object %s", absoluteTimeRangeConfig));
        }
        String string2 = endTime = absoluteTimeRangeConfig.hasPath("endTime") ? absoluteTimeRangeConfig.getString("endTime") : null;
        if (endTime == null) {
            throw new ConfigBuilderException(String.format("endTime is a required parameter in absoluteTimeRage config object %s", absoluteTimeRangeConfig));
        }
        String string3 = timeFormat = absoluteTimeRangeConfig.hasPath("timeFormat") ? absoluteTimeRangeConfig.getString("timeFormat") : null;
        if (timeFormat == null) {
            throw new ConfigBuilderException(String.format("timeFormat is a required parameter in absoluteTimeRage config object %s", absoluteTimeRangeConfig));
        }
        ConfigUtils.validateTimestampPatternWithEpoch("startTime", startTime, timeFormat);
        ConfigUtils.validateTimestampPatternWithEpoch("endTime", endTime, timeFormat);
        AbsoluteTimeRangeConfig configObj = new AbsoluteTimeRangeConfig(startTime, endTime, timeFormat);
        logger.debug((Object)"Built AbsoluteTimeRangeConfig object");
        return configObj;
    }
}

