/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.consumer;

import com.linkedin.feathr.core.config.consumer.FeatureBagConfig;
import com.linkedin.feathr.core.config.consumer.JoinConfig;
import com.linkedin.feathr.core.config.consumer.SettingsConfig;
import com.linkedin.feathr.core.configbuilder.typesafe.consumer.FeatureBagConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.consumer.SettingsConfigBuilder;
import com.linkedin.feathr.core.utils.Utils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class JoinConfigBuilder {
    private static final Logger logger = Logger.getLogger(JoinConfigBuilder.class);

    private JoinConfigBuilder() {
    }

    public static JoinConfig build(Config fullConfig) {
        SettingsConfig settings = null;
        if (fullConfig.hasPath("settings")) {
            Config config = fullConfig.getConfig("settings");
            settings = SettingsConfigBuilder.build(config);
        }
        HashMap<String, FeatureBagConfig> featureBags = new HashMap<String, FeatureBagConfig>();
        ConfigObject rootConfigObj = fullConfig.root();
        Set featureBagNameSet = rootConfigObj.keySet().stream().filter(fbn -> !fbn.equals("settings")).collect(Collectors.toSet());
        for (String featureBagName : featureBagNameSet) {
            List featuresConfigList = fullConfig.getConfigList(Utils.quote(featureBagName));
            FeatureBagConfig featureBagConfig = FeatureBagConfigBuilder.build(featuresConfigList);
            featureBags.put(featureBagName, featureBagConfig);
        }
        JoinConfig configObj = new JoinConfig(settings, featureBags);
        logger.debug((Object)"Built JoinConfig object");
        return configObj;
    }
}

