/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.consumer;

import com.linkedin.feathr.core.config.consumer.DateTimeRange;
import com.linkedin.feathr.core.config.consumer.KeyedFeatures;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.linkedin.feathr.core.utils.Utils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueType;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

class KeyedFeaturesConfigBuilder {
    private static final Logger logger = Logger.getLogger(KeyedFeaturesConfigBuilder.class);
    private static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");

    private KeyedFeaturesConfigBuilder() {
    }

    public static KeyedFeatures build(Config featuresConfig) {
        List<String> key = KeyedFeaturesConfigBuilder.getKey(featuresConfig);
        List features = featuresConfig.getStringList("featureList");
        DateTimeRange dates = KeyedFeaturesConfigBuilder.getDates(featuresConfig);
        Duration overrideTimeDelay = featuresConfig.hasPath("overrideTimeDelay") ? featuresConfig.getDuration("overrideTimeDelay") : null;
        return new KeyedFeatures(key, features, dates, overrideTimeDelay);
    }

    private static List<String> getKey(Config config) {
        ConfigValueType keyValueType = config.getValue("key").valueType();
        switch (keyValueType) {
            case STRING: {
                return Collections.singletonList(config.getString("key"));
            }
            case LIST: {
                return config.getStringList("key");
            }
        }
        throw new ConfigBuilderException("Expected key type String or List[String], got " + keyValueType);
    }

    private static DateTimeRange getDates(Config config) {
        DateTimeRange dateTimeParams;
        if (config.hasPath("startDate")) {
            String startDateStr = config.getString("startDate");
            String endDateStr = config.getString("endDate");
            LocalDateTime startDate = LocalDate.parse(startDateStr, dateTimeFormatter).atStartOfDay();
            LocalDateTime endDate = LocalDate.parse(endDateStr, dateTimeFormatter).atStartOfDay();
            dateTimeParams = new DateTimeRange(startDate, endDate);
        } else if (config.hasPath("dateOffset")) {
            int dateOffset = config.getInt("dateOffset");
            int numDays = config.getInt("numDays");
            String messageStr = String.format("Expected %s > 0 && %s > 0 && %s < %s; got %s = %d, %s = %d", "dateOffset", "numDays", "numDays", "dateOffset", "dateOffset", dateOffset, "numDays", numDays);
            Utils.require(numDays > 0 && numDays < dateOffset, messageStr);
            LocalDateTime startDate = LocalDate.now().minusDays(dateOffset).atStartOfDay();
            LocalDateTime endDate = startDate.plusDays(numDays);
            dateTimeParams = new DateTimeRange(startDate, endDate);
        } else {
            dateTimeParams = null;
        }
        return dateTimeParams;
    }
}

