/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.consumer;

import com.linkedin.feathr.core.config.consumer.AbsoluteTimeRangeConfig;
import com.linkedin.feathr.core.config.consumer.ObservationDataTimeSettingsConfig;
import com.linkedin.feathr.core.config.consumer.RelativeTimeRangeConfig;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.linkedin.feathr.core.configbuilder.typesafe.consumer.AbsoluteTimeRangeConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.consumer.RelativeTimeRangeConfigBuilder;
import com.typesafe.config.Config;
import org.apache.log4j.Logger;

public class ObservationDataTimeSettingsConfigBuilder {
    private static final Logger logger = Logger.getLogger(ObservationDataTimeSettingsConfigBuilder.class);

    private ObservationDataTimeSettingsConfigBuilder() {
    }

    public static ObservationDataTimeSettingsConfig build(Config observationDataTimeSettings) {
        RelativeTimeRangeConfig relativeTimeRangeConfig;
        AbsoluteTimeRangeConfig absoluteTimeRangeConfig = observationDataTimeSettings.hasPath("absoluteTimeRange") ? AbsoluteTimeRangeConfigBuilder.build(observationDataTimeSettings.getConfig("absoluteTimeRange")) : null;
        RelativeTimeRangeConfig relativeTimeRangeConfig2 = relativeTimeRangeConfig = observationDataTimeSettings.hasPath("relativeTimeRange") ? RelativeTimeRangeConfigBuilder.build(observationDataTimeSettings.getConfig("relativeTimeRange")) : null;
        if (absoluteTimeRangeConfig != null && relativeTimeRangeConfig != null) {
            throw new ConfigBuilderException(String.format("Please provide only one of the absoluteTimeRange or RelativeTimeRange. Currently, youhave provided both the configs:- AbsoluteTimeRange: %s , RelativeTimeRange: %s", absoluteTimeRangeConfig.toString(), relativeTimeRangeConfig.toString()));
        }
        if (absoluteTimeRangeConfig == null && relativeTimeRangeConfig == null) {
            throw new ConfigBuilderException(String.format("Please provide atleast one of absoluteTimeRange or RelativeTimeRange. If you do notintend to filter the observation data, please remove the section observationDataTimeSettings from the settings section.", absoluteTimeRangeConfig.toString(), relativeTimeRangeConfig.toString()));
        }
        ObservationDataTimeSettingsConfig configObj = new ObservationDataTimeSettingsConfig(absoluteTimeRangeConfig, relativeTimeRangeConfig);
        logger.debug((Object)"Built Observation data time settings object");
        return configObj;
    }
}

