/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.generation;

import com.linkedin.feathr.core.config.common.DateTimeConfig;
import com.linkedin.feathr.core.utils.ConfigUtils;
import com.typesafe.config.Config;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class DateTimeConfigBuilder {
    private static final Logger logger = Logger.getLogger(DateTimeConfigBuilder.class);
    private static final String DEFAULT_TIME_ZONE = "America/Los_Angeles";
    private static final String END_TIME = "endTime";
    private static final String END_TIME_FORMAT = "endTimeFormat";
    private static final String TIME_RESOLUTION = "resolution";
    private static final String OFFSET = "offset";
    private static final String LENGTH = "length";
    private static final String TIME_ZONE = "timeZone";

    private DateTimeConfigBuilder() {
    }

    public static DateTimeConfig build(Config config) {
        String endTIme = config.getString(END_TIME);
        String endTimeFormat = config.getString(END_TIME_FORMAT);
        String timeResolutionStr = config.getString(TIME_RESOLUTION);
        ChronoUnit timeResolution = ConfigUtils.getChronoUnit(timeResolutionStr);
        long length = ConfigUtils.getLongWithDefault(config, LENGTH, 0L);
        Duration offset = ConfigUtils.getDurationWithDefault(config, OFFSET, Duration.ofSeconds(0L));
        String timeZoneStr = ConfigUtils.getStringWithDefault(config, TIME_ZONE, DEFAULT_TIME_ZONE);
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneStr);
        DateTimeConfig dateTimeConfig = new DateTimeConfig(endTIme, endTimeFormat, timeResolution, length, offset, timeZone);
        logger.trace((Object)"Built DateTimeConfig object");
        return dateTimeConfig;
    }
}

