/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors;

import com.linkedin.feathr.core.config.producer.anchors.AnchorConfigWithExtractor;
import com.linkedin.feathr.core.config.producer.anchors.FeatureConfig;
import com.linkedin.feathr.core.config.producer.anchors.TypedKey;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.BaseAnchorConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.TypedKeyBuilder;
import com.linkedin.feathr.core.utils.ConfigUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueType;
import java.util.List;
import java.util.Map;
import javax.lang.model.SourceVersion;
import org.apache.log4j.Logger;

class AnchorConfigWithExtractorBuilder
extends BaseAnchorConfigBuilder {
    private static final Logger logger = Logger.getLogger(AnchorConfigWithExtractorBuilder.class);

    private AnchorConfigWithExtractorBuilder() {
    }

    public static AnchorConfigWithExtractor build(String name, Config config) {
        String extractorClassName;
        String source = config.getString("source");
        String string = extractorClassName = config.hasPath("extractor") ? AnchorConfigWithExtractorBuilder.getExtractorClassName(config) : AnchorConfigWithExtractorBuilder.getTransformerClassName(config);
        if (!SourceVersion.isName(extractorClassName)) {
            throw new ConfigBuilderException("Invalid class name for extractor: " + extractorClassName);
        }
        String extractor = extractorClassName;
        String keyExtractor = config.hasPath("keyExtractor") ? config.getString("keyExtractor") : null;
        TypedKey typedKey = TypedKeyBuilder.getInstance().build(config);
        List<String> keyAlias = ConfigUtils.getStringList(config, "keyAlias");
        if ((keyAlias != null || typedKey != null) && keyExtractor != null) {
            throw new ConfigBuilderException("The keyExtractor field and keyAlias field can not coexist.");
        }
        Map<String, FeatureConfig> features = AnchorConfigWithExtractorBuilder.getFeatures(config);
        AnchorConfigWithExtractor anchorConfig = new AnchorConfigWithExtractor(source, keyExtractor, typedKey, keyAlias, extractor, features);
        logger.trace((Object)("Built AnchorConfigWithExtractor object for anchor " + name));
        return anchorConfig;
    }

    private static String getExtractorClassName(Config config) {
        String extractorClassName;
        ConfigValueType valueType = config.getValue("extractor").valueType();
        switch (valueType) {
            case STRING: {
                extractorClassName = config.getString("extractor");
                break;
            }
            case OBJECT: {
                extractorClassName = config.getString("extractor.class");
                break;
            }
            default: {
                throw new ConfigBuilderException("Unknown value type " + valueType + " for key " + "extractor");
            }
        }
        return extractorClassName;
    }

    private static String getTransformerClassName(Config config) {
        return config.getString("transformer");
    }
}

