/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors;

import com.linkedin.feathr.core.config.producer.anchors.AnchorConfigWithKey;
import com.linkedin.feathr.core.config.producer.anchors.FeatureConfig;
import com.linkedin.feathr.core.config.producer.anchors.LateralViewParams;
import com.linkedin.feathr.core.config.producer.anchors.TypedKey;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.BaseAnchorConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.LateralViewParamsBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.TypedKeyBuilder;
import com.linkedin.feathr.core.utils.ConfigUtils;
import com.typesafe.config.Config;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

class AnchorConfigWithKeyBuilder
extends BaseAnchorConfigBuilder {
    private static final Logger logger = Logger.getLogger(BaseAnchorConfigBuilder.class);

    private AnchorConfigWithKeyBuilder() {
    }

    public static AnchorConfigWithKey build(String name, Config config) {
        String source = config.getString("source");
        TypedKey typedKey = TypedKeyBuilder.getInstance().build(config);
        Map<String, FeatureConfig> features = AnchorConfigWithKeyBuilder.getFeatures(config);
        List<String> keyAlias = ConfigUtils.getStringList(config, "keyAlias");
        if (keyAlias != null && keyAlias.size() != typedKey.getKey().size()) {
            throw new ConfigBuilderException("The size of key and keyAlias does not match");
        }
        LateralViewParams lateralViewParams = AnchorConfigWithKeyBuilder.hasTimeWindowFeatureConfig(features) && config.hasPath("lateralViewParameters") ? LateralViewParamsBuilder.build(name, config.getConfig("lateralViewParameters")) : null;
        AnchorConfigWithKey anchorConfig = new AnchorConfigWithKey(source, typedKey, keyAlias, lateralViewParams, features);
        logger.trace((Object)("Built AnchorConfigWithKey object for anchor " + name));
        return anchorConfig;
    }
}

