/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors;

import com.linkedin.feathr.core.config.producer.anchors.AnchorConfigWithKeyExtractor;
import com.linkedin.feathr.core.config.producer.anchors.FeatureConfig;
import com.linkedin.feathr.core.config.producer.anchors.LateralViewParams;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.BaseAnchorConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.LateralViewParamsBuilder;
import com.typesafe.config.Config;
import java.util.Map;
import javax.lang.model.SourceVersion;
import org.apache.log4j.Logger;

class AnchorConfigWithKeyExtractorBuilder
extends BaseAnchorConfigBuilder {
    private static final Logger logger = Logger.getLogger(AnchorConfigWithKeyExtractorBuilder.class);

    private AnchorConfigWithKeyExtractorBuilder() {
    }

    public static AnchorConfigWithKeyExtractor build(String name, Config config) {
        String source = config.getString("source");
        String className = config.getString("keyExtractor");
        if (!SourceVersion.isName(className)) {
            throw new ConfigBuilderException("Invalid class name for keyExtractor: " + className);
        }
        String keyExtractor = className;
        if (config.hasPath("keyAlias")) {
            throw new ConfigBuilderException("keyAlias and keyExtractor are mutually exclusive fields");
        }
        Map<String, FeatureConfig> features = AnchorConfigWithKeyExtractorBuilder.getFeatures(config);
        LateralViewParams lateralViewParams = AnchorConfigWithKeyExtractorBuilder.hasTimeWindowFeatureConfig(features) && config.hasPath("lateralViewParameters") ? LateralViewParamsBuilder.build(name, config.getConfig("lateralViewParameters")) : null;
        AnchorConfigWithKeyExtractor anchorConfig = new AnchorConfigWithKeyExtractor(source, keyExtractor, features, lateralViewParams);
        logger.trace((Object)("Built AnchorConfigWithExtractor object for anchor " + name));
        return anchorConfig;
    }
}

