/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors;

import com.linkedin.feathr.core.config.producer.anchors.AnchorConfig;
import com.linkedin.feathr.core.config.producer.anchors.AnchorsConfig;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.AnchorConfigBuilder;
import com.linkedin.feathr.core.utils.Utils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;

public class AnchorsConfigBuilder {
    private static final Logger logger = Logger.getLogger(AnchorsConfigBuilder.class);

    private AnchorsConfigBuilder() {
    }

    public static AnchorsConfig build(Config config) {
        ConfigObject configObj = config.root();
        Stream anchorNames = configObj.keySet().stream();
        Map<String, AnchorConfig> nameConfigMap = anchorNames.collect(Collectors.toMap(Function.identity(), aName -> AnchorConfigBuilder.build(aName, config.getConfig(Utils.quote(aName)))));
        AnchorsConfig anchorsConfig = new AnchorsConfig(nameConfigMap);
        logger.debug((Object)"Built all AnchorConfig objects");
        return anchorsConfig;
    }
}

